'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './settlenochance.less';
import { Button, Toast } from '@grace/ui';
import { _asyncThrottle } from "../../utils/utils";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import { LOG_KEY, MatterShareOpt, MatterViewDuration, MatterViewOpt, pageView, sensorLog } from "../../utils/sensors.js";

@observer
class Settlenochance extends React.Component {
  constructor(props) {
    super(props);
  }
  componentDidMount(){
    pageView("b14276", {
      page_name: "结算弹窗",
    });
    sensorLog(LOG_KEY.exposure, "b14276", "d14279", {
      page_name: "结算弹窗",
      button_name: "关闭按钮",
    });
    sensorLog(LOG_KEY.exposure, "b14276", "d14277", {
      page_name: "结算弹窗",
      button_name: "我知道了按钮",
    });
  }
  onClose = ()=>{
    ModalCtrl.closeModal()
    sensorLog(LOG_KEY.click, "b14276", "d14279", {
      page_name: "结算弹窗",
      button_name: "关闭按钮",
    });
  }
  onClose2 = ()=>{
    ModalCtrl.closeModal()
    sensorLog(LOG_KEY.click, "b14276", "d14277", {
      page_name: "结算弹窗",
      button_name: "我知道了按钮",
    });
  }
  render() {
    return (
      <div className="settlenochance modal_center">
        <span className="dongxiao"></span>
        <span className="bg"></span>
        <span className="know"></span>
        <span className="icon"></span>
        <span className="title"></span>
        <span className="tip1">获得了「宇宙菜鸟」称号</span>
        <span className="tip2">你的脑洞像刚解冻的冰棍——梆硬且毫无波澜，建议多喝热水重启大脑！</span>
        <span className="close"></span>
      </div>
    );
  }
}
export default Settlenochance;
