import { generateAPI } from "./utils"

const API = generateAPI({
  /** 获取活动规则 */
  getRule: "projectRule.query",
  /** 获取前端配置项 */
  getFrontVariable: "coop_frontVariable.query",
  /** 参与接口 post请求 */
  doJoin: {
    uri: "join.do",
    method: "post"
  },
  /** 签到 */
  doSign: {
    uri: "checkin_1/doSign.do",
    withToken: true,  // 携带token
  },

  // cookie丢失-临时保存cookie
  tempSaveCookie: {
    uri: "/autoLogin/tempSaveCookie",
    showMsg: false,
  },
  // cookie丢失-重新设置cookie
  resetCookie: "/autoLogin/resetCookie",
  userLogin: {
    uri: "userLogin.check",
    showMsg: false,
  },

  // 奖品记录
  records: "common/records.do",
  // 红包补领
  redpacket: "common/moneyReissue.do",

  getInviteCode: {
    uri: 'inviteAssist_1/getInviteCode.do',
    withToken: true,
    method: 'post',
  },
  doAssist: {
    uri: 'inviteAssist_1/doAssist.do',
    withToken: true,
    method: 'post',
    showMsg: false,
  },
  /** 获取地区 */
  getParentCode: "/gaw/address/getChildrenByParentCode",

  // 挑战-首页
  getChallengeIndex: "challenge/index.do",

  //挑战-基础首页
  getChallengeBaseIndex: "challenge/baseIndex.do",

  // 挑战-补签
  getChallengeResign: "challenge/resign.do",

  // 挑战-任务完成接口
  getChallenegeComplete: "challenge/taskComplete.do",

  //挑战-获取邀请码
  getChallengeInviteCode: "challenge/inviteCode.do",

  // 挑战-助力
  getChallengeAssist: {
    uri: "challenge/assist.do",
    showMsg: false,
  },

  // 挑战-选择挑战
  getChooseChallenge: "challenge/chooseChallenge.do",

  // 扣积分
  queryStatus: "credits/queryStatus.do",
  creditsCost: {
    uri: "credits/creditsCost.do",
    method: "post"
  },

  // 奖品
  queryOrder: "/customActivity/kouweiwang/prize/queryOrderNo",

  index: "zqdn/index.do",
  completeGuide: "main/completeGuide.do",
  sign: "main/sign.do",
  receiveBubble: "main/receiveBubble.do",
  startVideo: "main/startVideo.do",

  /** 奖品页 */
  prize: "/crecord/getrecordmn",
  /** 获取任务列表 */
  getTaskInfo: {
    uri: "task_1/queryTasks.do",
  },
  /** 完成任务 */
  doCompleted: {
    uri: "task_1/doCompleted.do",
    method: "post",
    withToken: true,
  },
  /** 领取奖励 */
  sendPrize: {
    uri: "task_1/sendPrize.do",
    method: "post",
    withToken: true,
  },

  // 推送使用
  outside: {
    uri: `inviteAssist_1/outside.do`,
    widthToken: true,
  },

  // 推送使用
  assistJoin: {
    uri: `inviteAssist_1/join.do`,
    widthToken: true,
  },

  bindPhone: {
    uri: "/customActivity/piccLife/bindWithCode",
    method: "post",
    showMsg: false,
  },


  /** 扭蛋机首页 */
  drawIndex: "ndj/index.do",
  /** 扭蛋机抽奖 */
  drawJoin: {
    uri: "ndj/draw.do",
    withToken: true,
  },

  /** 校验验证码并登录 */
  coopCheckCode: {
    uri: "examine/coop_checkCode.do",
    method: "post",
  },

  getCode: {
    uri: "/customActivity/piccLife/sendSmsCode",
    // showMsg: false,
  },

  /** 发送验证码 */
  coopSendCode: {
    uri: "examine/coop_sendCode.do",
    method: "post",
  },
  /** 校验是否绑定手机号 */
  checkBind: "/customActivity/piccLife/check",

  ////////////////////////////////////////////////////////


  /** 同意隐私协议接口*/
  agreePrivacy: "main/agreePrivacy.do",

  buriedPoint: {
    uri: "home/buriedPoint.do",
    showMsg: false,
  },

  /** 生成唤端二维码 */
  getLongLinkQrcode: `/customActivity/qrcode/getQrcode`,

  queryInviteRecords: "inviteAssist_1/queryInviteRecords.do",


  /**数据推送 */
  visit:`common/visit.do`,
  /** 绑定友客业务员信息接口 */
  bindYk: {
    uri: "common/bindYk.do",
    method: "post",
    showMsg: false,
  },
  /** 落地页 */
  coop_getLoadingInfo: "common/outside.do",
  rankInfo:`zqdn/rankIndex.do`,

  ////////////////////////////// Game //////////////////////////////
  start:`/zqdn/start.do`,
  suggest:`/zqdn/suggest.do`,
  middleSubmit:`/zqdn/middleSubmit.do`,
  submit:`/zqdn/submit.do`,


})

// console.log('======', API)

export default API
