import { LevelBase } from "@/pages/GamePage/Components/LevelBase.ts";
import { Assets, Sprite } from "pixi.js";
import { Ease, Tween } from "@/core/tween";
import { GameEvent, globalEvent } from "@/pages/GamePage/GameEvent.ts";

export class Level25 extends LevelBase {

  level: number = 25;

  right: Sprite;
  sleepPig: Sprite;
  sleepMark: Sprite;
  hideMark: Sprite;
  redFace: Sprite;
  mad: Sprite;
  wake: Sprite;
  gameOver = false;

  trueArea = false;

  onLoad() {
    super.onLoad();

    this.sleepPig = this.addChild(new Sprite(Assets.get(`level25/img.png`)));
    this.sleepPig.position.set(114, 785);

    this.sleepMark = this.addChild(new Sprite(Assets.get(`level25/sleep.png`)));
    this.sleepMark.position.set(100, 778);

    this.hideMark = this.addChild(new Sprite(Assets.get(`level25/hide.png`)));
    this.hideMark.position.set(173, 931);
    this.hideMark.alpha = 0;

    this.redFace = this.addChild(new Sprite(Assets.get(`level25/redFace.png`)));
    this.redFace.position.set(116, 813);
    this.redFace.alpha = 0;

    this.mad = this.addChild(new Sprite(Assets.get(`level25/mad.png`)));
    this.mad.position.set(175, 936);
    this.mad.alpha = 0;

    this.wake = this.addChild(new Sprite(Assets.get(`level25/wake.png`)));
    this.wake.position.set(175, 936);
    this.wake.alpha = 0;

    this.right = this.addChild(new Sprite(Assets.get(`common/right.png`)));
    this.right.position.set(535, 995);
    this.right.alpha = 0;
    this.right.interactive = false;
    this.right.eventMode = "none";

    this.on("pointerdown", this.onNosePointerDown, this);
    this.on("pointerup", this.onNosePointerUp, this);

  }

  onNosePointerDown(e) {

    const { x, y } = e.data.global;

    if(x >=182 && x <= 260 && y >= 954 && y <= 1024) {
      this.trueArea = true;
    } else {
      this.trueArea = false;
    }

    if(this.gameOver) return;

    if(!this.trueArea) return

    this.mad.alpha = 1;
    this.hideMark.alpha = 1;
    Tween.get(this.redFace)
    .to({ alpha: 1 }, 3000)
    .call(() => {
      this.gameOver = true;


      this.mad.alpha = 0;
      this.redFace.alpha = 0;
      this.wake.alpha = 1;
      this.hideMark.alpha = 0;
      this.setPauseCd(true);
      Tween.get(this.right)
      .to({ alpha: 1 }, 444, Ease.quadInOut)
      .wait(2000)
      .call(() => {
        globalEvent.emit(GameEvent.NextLevel);
      });

    })

  }

  onNosePointerUp(e) {

    if(this.gameOver) return;

    if(!this.trueArea) return
    Tween.removeTweens(this.redFace);

    this.hideMark.alpha = 0;
    this.redFace.alpha = 0;
    this.mad.alpha = 0;

  }

  onDestroy() {
    super.onDestroy();
    Tween.removeTweens(this.redFace);
    Tween.removeTweens(this.right);
  }
}
