import { Assets, PointData, Sprite, Ticker } from "pixi.js";
import 'pixi.js/math-extras';
import { Base } from "@/core/pixi/base/Base.ts";
import { observer, reactor } from "./mobx/decorators.ts";
import { GameEvent, globalEvent } from "./GameEvent.ts";
import { Level1 } from "@/pages/GamePage/Level/Level1.ts";
import { Level2 } from "@/pages/GamePage/Level/Level2.ts";
import { Level3 } from "@/pages/GamePage/Level/Level3.ts";

@observer
export class Game extends Base {

  onLoad() {
    const qsBg = this.addChild(new Sprite(Assets.get("问题.png")));
    qsBg.position.set(49, 316);

    this.addChild(new Level3());

    globalEvent.on(GameEvent.ReceiveEffect, this.receiveEffect, this);
  }

  receiveEffect(point: PointData) {

  }

  onUpdate(time: Ticker) {
    // const dt = time.deltaMS / 1000;
  }

  onDestroy() {
  }
}
