import { Base, IBase } from "@/core/pixi/base/Base.ts";
import { Assets, Container, Sprite, Ticker } from "pixi.js";

export abstract class LevelBase extends Base {

  abstract level: number;
  qs: Sprite;

  onLoad() {
    this.qs = this.addChild(new Sprite(Assets.get(`level${this.level}/qs.png`)));
    this.qs.anchor.set(0.5);
    this.qs.position.set(375, 505);
  }

  onUpdate(time: Ticker) {

  }

  onDestroy() {
  }

  destroy() {
    this.onDestroy();
    super.destroy();
  }

}
