/*
 * @Author: super
 * @Date: 2021-01-20 14:08:27
 * @LastEditTime: 2021-01-20 14:53:39
 * @LastEditors: super
 * @Description:
 */

import { isMiniprogram, isIos } from "./utils";

/** 渠道参数 */
export const CHANNEL_PARAMS = {
  /** 人保寿险管家app */
  RB_APP: 1,
  /** 人保寿险企业家助手微信公众号 */
  RB_WX_PUBLIC: 2,
  /** 友客微信公众号 */
  YK_PUBLIC: 3,
  /** 人保寿险E服务公众号h5 */
  E_MINI: 4,
  /** 友客小程序 */
  YK_MINI: 5,
  /** e通app */
  ET_APP: 6,
  /** 微通（企业微信） */
  WT_YK_PUBLIC: 7,
  /** 友客获客公众号 */
  YKHK_PUBLIC: 8,
};

/* 电话号码验证规则 **/
export const REG_TEL = /^1[0-9]{10}$/;

/**
 * 任务code
 * 3. 保豆签到任务，code为：sign；
 * 4. 展示渠道不做过滤展示，可直接在展示渠道完成的浏览任务，如：浏览美满赢家、浏览康宁嘉倍、浏览运动意外伤害保险 等，code以：btt1_ 开头，示例：btt1_1、btt1_2、btt1_zx1
 * 5. 友客端需要做特殊展示限制的浏览任务，如：浏览关爱百万医疗、浏览关爱百万2019医疗保险组合、乐业福 等，code以：btt2_ 开头，示例：btt2_1、btt2_2、btt2_3；产品组合编码配置在任务描述里面，示例：1111、2222；
 * 6. app端展示，但不可完成的浏览任务，如：浏览企业人人保、浏览畅行保产品计划A赠险、浏览畅行保产品计划B赠险 等，code以：btt3_ 开头，示例：btt3_1、btt3_zx2、btt3_zx3；
 * 7. 赠险浏览任务，不需要浏览7s，code包含zx；
 */
export const TASK_CODE = {
  /** 签到任务 */
  THIRD_SIGN: "sign",
  /** 答题任务 */
  ANSRWER: "common_answer",
  /** 分享任务 */
  SHARE: "share",
  /** 留资任务 */
  FILL: "common_fill",
  /** 邀请任务 */
  INVITE: "invite",
  /** 正常展示的浏览任务：app内有秒限制，根据端内跳转回调算完成；友客端需要链接后拼code值 */
  BROWSE_COMMON: "browse_",
  /** 友客端需要做销售限制特殊展示的浏览任务：app内有秒限制，根据端内跳转回调算完成；友客端不需要链接后拼code值 */
  BROWSE_AREA: "btt2_",
  /** 展示特殊处理浏览任务：app端不展示去完成按钮 */
  BROWSE_SPECIAL_SHOW: "btt3_",
  /** 浏览赠险任务（会在bttx_后面追加_zx进行区分）：app内无秒限制，点击即完成；友客端需要链接后拼code值 */
  BROWSE_INSURE: "_zx",
};

/* 表情包 正则 **/
export const emojiReg = /(\ud83c[\udf00-\udfff])|(\ud83d[\udc00-\ude4f\ude80-\udeff])|[\u2600-\u2B55]/g;
/* 特殊字符 正则 **/
export const specialStrReg =
  /[`~!@#$%^&*()_\-+=<>?:"{}|,./;'\\[\]·~！@#￥%……&*（）——\-+={}|《》？：“”【】、；‘'，。、「」]/g;

export const platFormName = {
  /** 人保寿险管家app */
  1: "人保寿险管家app",
  /** 人保寿险企业家助手微信公众号 */
  2: "人保寿险E服务",
  /** 友客微信公众号 */
  3: "友客微信公众号",
  /** 人保寿险E服务公众号h5 */
  4: "e服务公众号",
  /** 友客小程序 */
  5: "人保友客",
  /** e通app */
  6: "人保e通-寿险板块",
  /** 微通（企业微信） */
  7: "微通（企业微信）",
  /** 友客获客公众号 */
  8: isMiniprogram() ? "人保友客" : "友客微信公众号",
};

export const platformType = {
  /** 人保寿险管家app */
  1: isIos() ? "iOS" : "Android",
  /** 人保寿险企业家助手微信公众号 */
  2: "微信公众号",
  /** 友客微信公众号 */
  3: "微信公众号",
  /** 人保寿险E服务公众号h5 */
  4: "微信公众号",
  /** 友客小程序 */
  5: "微信小程序",
  /** e通app */
  6: isIos() ? "iOS" : "Android",
  /** 微通（企业微信） */
  7: "微信公众号",
  /** 友客获客公众号 */
  8: isMiniprogram() ? "微信小程序" : "微信公众号",
};

export const extranceName = {
  1: "人保寿险管家app",
  2: "人保寿险企业家助手微信公众号",
  3: "友客微信公众号",
  4: "e服务公众号",
  5: "人保友客",
  6: "人保e通-寿险板块",
  7: "微通（企业微信）",
  8: "人保友客",
};
