"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./settlechance.less";
import { Button, Toast } from "@grace/ui";
import { _asyncThrottle } from "../../utils/utils";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import { SvgaPlayer } from "@grace/svgaplayer";

import lightSvga from "../../assets/svga/6输出弹窗.svga";
import Capsulepage from "../../pages/CapsulePage/CapsulePage";
import HomePage from "../../pages/HomePage/HomePage";
@observer
class Settlechance extends React.Component {
  constructor(props) {
    super(props);
  }
  componentDidMount(){
    pageView("b14276", {
      page_name: "结算弹窗",
    });
    sensorLog(LOG_KEY.exposure, "b14276", "d14279", {
      page_name: "结算弹窗",
      button_name: "关闭按钮",
    });
    sensorLog(LOG_KEY.exposure, "b14276", "d14277", {
      page_name: "结算弹窗",
      button_name: "我知道了按钮",
    });
    sensorLog(LOG_KEY.exposure, "b14276", "d14278", {
      page_name: "结算弹窗",
      button_name: "去抽奖按钮",
    });
  }
  handleClose = _asyncThrottle(() => {
    ModalCtrl.closeModal()
    PageCtrl.changePage(HomePage)
    sensorLog(LOG_KEY.click, "b14276", "d14279", {
      page_name: "结算弹窗",
      button_name: "关闭按钮",
    });
  })

  handleKnow = _asyncThrottle(() => {
    ModalCtrl.closeModal()
    PageCtrl.changePage(HomePage)
    sensorLog(LOG_KEY.click, "b14276", "d14277", {
      page_name: "结算弹窗",
      button_name: "我知道了按钮",
    });
  })

  handleDraw = _asyncThrottle(() => {
    ModalCtrl.closeModal()
    PageCtrl.changePage(Capsulepage)
    sensorLog(LOG_KEY.click, "b14276", "d14278", {
      page_name: "结算弹窗",
      button_name: "去抽奖按钮",
    });
  })



  render() {
    const { data } = this.props || {};
    const {
      drawChance = 0,
      title = "",
      desc = "",
      img = "",
      score = 0,
    } = data || {};
    return (
      <div className="settlechance modal_center">
        <SvgaPlayer className="light" src={lightSvga} />
        <span className="bg"></span>
        <Button className="draw md19" onClick={this.handleDraw} />
        <Button className="know md17" onClick={this.handleKnow} />
        <img className="icon"
          src = {img}
          alt = {title}
        />
        <span className="ribbon"></span>
        <span className="title">恭喜您, 答对{score}题</span>
        <span className="tip1">获得了「{title}」称号</span>
        <span className="tip2">{desc}</span>
        <span className="tip3">恭喜获得抽奖机会+{drawChance}</span>
        <Button className="close md18" onClick={this.handleClose} />
      </div>
    );
  }
}
export default Settlechance;
