import React from 'react';
import { observer } from 'mobx-react';
import './HomePage.less';
import { getUrlParam } from "@/utils/utils.ts";
import store from "@/store/store.ts";
import { Button } from "@grace/ui";
import MyPrize from '../MyPrize/MyPrize';
import Rule from '../RulePage/RulePage';
import { PageCtrl } from '@/core/ctrls/PageCtrl';

import { SvgaPlayer } from "@grace/svgaplayer";

import lightSvga from "@/assets/svga/5光点飘散.svga";

@observer
class HomePage extends React.Component<any, any> {

  root: HTMLDivElement;

  async componentDidMount () {
    await store.doAssist();
    store.updateIndex();
  }

  clickPrize = () => {
    PageCtrl.changePage(MyPrize);
  }

  clickRule = () => {
    PageCtrl.changePage(Rule);
  }

  clickCredits = () => {
    wx.miniProgram.navigateTo({ url: "/packages/user/points?source=duiba" });
  }

  render() {
    const { creditsNum, guideFlag } = store.indexData
    return <>
      <div className="homepage" ref={(el) => this.root = el}>
        <div className="homeRoot">
          <SvgaPlayer className="homeSvga" src={lightSvga} />

          <Button className="credits"
                  onClick={this.clickCredits}>{creditsNum > 999999 ? "999999+" : creditsNum}</Button>
          {/*<Button className="cash"><span>￥</span>32.88</Button>*/}

          <Button className="rule" onClick={this.clickRule} />
          <Button className="prize" onClick={this.clickPrize} />
        </div>

      </div>
      {/*{!guideFlag && <GuidePanel />}*/}
    </>;
  }
}

export default HomePage;
