import React from "react";
import {observer} from "mobx-react";
import "./SignSucPanel.less";
import {Button} from "@grace/ui";
import {_asyncThrottle} from "@/utils/utils.ts";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import HomePage from "@/pages/HomePage/HomePage.tsx";
import { SvgaPlayer } from "@grace/svgaplayer";

import bgEffectSvga from "@/assets/svga/2输出签到成功弹窗.svga";

export interface ISignSucPanelProps {
  signCredits: number;
  extraCredits: number;
  boolLimit: boolean;
  multipleValue: number;
  url: string;
  taskId: string;
  newLuckCreditsNum: number;
}

@observer
class SignSucPanel extends React.Component<ISignSucPanelProps> {

  componentDidMount() {
  }

  clickClose = () => {
    ModalCtrl.closeModal();
  };

  clickBtn = _asyncThrottle(async () => {
    ModalCtrl.closeModal();
  });

  render() {
    const { signCredits, extraCredits } = this.props;

    return <div className="SignSucPanel modal_center">
      <SvgaPlayer className="bgEffect" src={bgEffectSvga}/>
      <div className="bg"/>
      <div className="title"/>

      {
        !!extraCredits
          ? <div className="vip">
            <div className="tip">获得</div>
            <div className="left">{signCredits}积分</div>
            <div className="right">{extraCredits}积分</div>
            <div className="img"/>
          </div>
          : <div className="normal">
            <div className="tip">获得{signCredits}积分</div>
            <div className="img"/>
          </div>
      }

      <div className="com_banner"/>

      <Button className="btn" onClick={this.clickBtn}/>
      <Button className="close" onClick={this.clickClose}/>
    </div>;
  }
}

export default SignSucPanel;
