'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './homepage.less';
import { Button, Toast } from '@grace/ui';
import { _asyncThrottle } from "../../utils/utils";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import Rulepop from "../../components/rulepop/rulepop.jsx";
import CapsulePage from "../CapsulePage/CapsulePage.jsx";
import store from '@/store/store';
import Taskpop from '@/panels/taskpop/taskpop.jsx';
import Yinsirulepop from '@/panels/yinsirulepop/yinsirulepop.jsx';
import RankPage from '../RankPage/RankPage.js';
import MyPrize from '../MyPrize/MyPrize.jsx';
import shareStore from '@/store/share.js';
import { LOG_KEY, MatterShareOpt, MatterViewDuration, MatterViewOpt, pageView, sensorLog } from "@/utils/sensors.js";
import { CHANNEL_PARAMS, extranceName } from '@/utils/constants.js';
import gameStore from "@/store/gameStore.ts";
import GamePage from "@/pages/GamePage/GamePage.tsx";

import Settlechance from "../../components/settlechance/settlechance.jsx"

@observer
class Homepage extends React.Component {
  constructor(props) {
    super(props);

    this.handleButtonClick = this.handleButtonClick.bind(this);
  }

  async componentDidMount() {
    await store.updateIndex();
    await shareStore.doAssist();
    this.initSensor();
  }

  handleButtonClick = _asyncThrottle(async (number) => {
    // 活动时间判断
    // 规则 奖品始终可以点击 我的排名结束可以点击 其余常规逻辑
    if (!(number === 0 || number === 4 || number === 5)) {
      if ((!store.judgeActTime(true, true))) return;
    }
    if ((number === 0)) {
      if ((!store.judgeActTime(true, false))) return;
    }
    switch (number) {
      // 0 我的排名
      case 0:
        // TODO 换成我的排名页面 记得引用
        sensorLog(LOG_KEY.click, "b14261", "d14264", {
          page_name: "活动首页",
          button_name: "我的排名按钮",
        });
        PageCtrl.changePage(RankPage);
        break;

      // 1 抽奖
      case 1:
        sensorLog(LOG_KEY.click, "b14261", "d14266", {
          page_name: "活动首页",
          button_name: "抽奖按钮",
        });
        PageCtrl.changePage(CapsulePage);
        break;

      // 2 做任务
      case 2:
        // TODO
        sensorLog(LOG_KEY.click, "b14261", "d14267", {
          page_name: "活动首页",
          button_name: "做任务，赚次数按钮",
        });
        ModalCtrl.showModal(Taskpop);
        break;

      // 3 答题
      case 3:
        // TODO
        sensorLog(LOG_KEY.click, "b14261", "d14265", {
          page_name: "活动首页",
          button_name: "开始答题按钮",
        });

        const suc = await gameStore.start();
        if (suc) {
          PageCtrl.changePage(GamePage);
        }

        break;

      // 4 我的奖品
      case 4:
        // TODO 换成我的奖品页面 记得引用
        sensorLog(LOG_KEY.click, "b14261", "d14263", {
          page_name: "活动首页",
          button_name: "奖品按钮",
        });
        if (!store.indexData?.agreePrivacy) {
          ModalCtrl.showModal(Yinsirulepop);
        } else {
          PageCtrl.changePage(MyPrize);
        }
        
        break;

      // 5 活动规则
      case 5:
        sensorLog(LOG_KEY.click, "b14261", "d14262", {
          page_name: "活动首页",
          button_name: "规则按钮",
        });
        ModalCtrl.showModal(Settlechance);
        break;

      // 6 拜访清单
      case 6:
        // TODO
        sensorLog(LOG_KEY.click, "b14268", "d14268", {
          page_name: "友客首页",
          button_name: "拜访清单按钮",
        });
        
        break;

      // 7 分享活动
      case 7:
        // TODO
        MatterShareOpt("b14268", "d14322", {
          button_name: "分享活动按钮",
          page_name: "友客首页",
        })
        shareStore.doShare();
        break;

      default:
        console.warn("未知按钮类型", number);
    }
  })
  initSensor = () => {
    if (CFG.channel == CHANNEL_PARAMS.YK_MINI) {
      sensorLog(LOG_KEY.exposure, "b14268", "d14322", {
        page_name: "友客首页",
        button_name: "分享活动按钮",
      });
    }

    if (CFG.channel == CHANNEL_PARAMS.YK_MINI || CFG.channel == CHANNEL_PARAMS.YK_PUBLIC) {
      MatterViewOpt("b14268", {
        page_name: "友客首页",
      })
      if (store?.indexData?.isAgent) {
        sensorLog(LOG_KEY.exposure, "b14268", "d14269", {
          page_name: "友客首页",
          button_name: "拜访清单按钮",
        });
      }
    }

    pageView("b14261", {
      page_name: "活动首页"
    });

    sensorLog(LOG_KEY.exposure, "b14261", "d14267", {
      page_name: "活动首页",
      button_name: "做任务，赚次数按钮",
    });
    sensorLog(LOG_KEY.exposure, "b14261", "d14266", {
      page_name: "活动首页",
      button_name: "抽奖按钮",
    });
    sensorLog(LOG_KEY.exposure, "b14261", "d14265", {
      page_name: "活动首页",
      button_name: "开始答题按钮",
    });
    sensorLog(LOG_KEY.exposure, "b14261", "d14264", {
      page_name: "活动首页",
      button_name: "我的排名按钮",
    });
    sensorLog(LOG_KEY.exposure, "b14261", "d14263", {
      page_name: "活动首页",
      button_name: "奖品按钮",
    });
    sensorLog(LOG_KEY.exposure, "b14261", "d14262", {
      page_name: "活动首页",
      button_name: "规则按钮",
    });
  };
  render() {
    return (
      <div className="homepage">
        <span className="bg"></span>
        <span className="equipment"></span>
        <span className="icon"></span>
        <span className="book"></span>
        <span className="brain"></span>
        <span className="wenhao"></span>
        <span className="title"></span>
        {/* 按钮 共7个 */}
        <div className="rank">
          <span className="r_bg"></span>
          <span className="name">用户uid:132802</span>
          <span className="head"></span>
          <Button className="myrank" onClick={() => this.handleButtonClick(0)} />
          <span className="number">000</span>
        </div>
        <span className="logo"></span>
        <Button className="draw" onClick={() => this.handleButtonClick(1)} />
        <Button className="task" onClick={() => this.handleButtonClick(2)} />
        <Button className="matter" onClick={() => this.handleButtonClick(3)}>
          <span className="m_bg"></span>
          <span className="answer"></span>
          <span className="remain">剩余次数：3</span>
        </Button>
        <Button className="prize" onClick={() => this.handleButtonClick(4)} />
        <Button className="rule" onClick={() => this.handleButtonClick(5)} />
        <Button className="visit" onClick={() => this.handleButtonClick(6)} />
        <Button className="share" onClick={() => this.handleButtonClick(7)} />
      </div>
    );
  }
}
export default Homepage;
