import { observer } from 'mobx-react';
import React, { Component } from 'react';
import './exitPop.less';
import { Button } from '@grace/ui';
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import HomePage from '@/pages/HomePage/HomePage.tsx';

@observer
class ExitPop extends Component {

  closeModal = () => {
    ModalCtrl.closeModal();
  }

  backHome = () => {
    PageCtrl.changePage(HomePage)
    this.closeModal();
  }

  render() {
    return (
      <div className="exitPop modal_center">
        <div className="bg"></div>
        <Button className="continueBtn" onClick={this.closeModal}></Button>
        <Button className="sureBtn" onClick={this.backHome}></Button>
        <Button className="closeBtn" onClick={this.closeModal}></Button>
      </div>
    );
  }
}

export default ExitPop;
