import { LevelBase } from "@/pages/GamePage/Components/LevelBase.ts";
import { Assets, Sprite } from "pixi.js";
import { Ease, Tween } from "@/core/tween";
import { GameEvent, globalEvent } from "@/pages/GamePage/GameEvent.ts";
import { rightWaitTime } from "@/pages/GamePage/Level/LevelConfig.ts";

export class Level16 extends LevelBase {

  level: number = 16;

  A: Sprite;
  B: Sprite;

  right: Sprite;

  onLoad() {
    super.onLoad();

    // this.addChild(new Sprite(Assets.get(`level${this.level}/C.png`)))
    //   .position.set(207, 902);

    this.B = this.addChild(new Sprite(Assets.get(`level${this.level}/B.png`)));
    this.B.position.set(293, 1035);

    this.A = this.addChild(new Sprite(Assets.get(`level${this.level}/A.png`)));
    this.A.position.set(105, 667);

    this.right = this.addChild(new Sprite(Assets.get(`level${this.level}/right.png`)));
    this.right.position.set(560, 1185);
    this.right.alpha = 0;
    this.right.interactive = false;
    this.right.eventMode = "none";

    this.A.on("pointerdown", this.onAPointerDown, this);
    this.A.on("pointerup", this.onAPointerUp, this);
    this.A.on("globalpointermove", this.onAPointerMove, this);
  }

  pos = null;

  onAPointerUp(e) {
    this.pos = null;
  }

  onAPointerDown(e) {
    const { x, y } = e.data.global;
    this.pos = {
      x: x - this.A.x,
      y: y - this.A.y
    }
  }

  onAPointerMove(e) {
    if (!this.pos) return;
    const { x, y } = e.data.global;
    const nx = x - this.pos.x;
    const ny = y - this.pos.y;
    this.A.position.set(nx, ny);

    if (
      nx >= 0
      && nx <= 228
      && ny >= 920
      && ny <= 1034
    ) {
      this.setPauseCd(true);
      this.setTouchEnable(false);
      // Tween.get(this.B).to({ alpha: 0 }, 444, Ease.quadInOut);
      Tween.get(this.A)
        .to({ x: 101, y: 946 }, 444, Ease.quadInOut)
        .call(() => {
          Tween.get(this.right)
            .to({ alpha: 1 }, 444, Ease.quadInOut)
            .wait(rightWaitTime)
            .call(() => {
              globalEvent.emit(GameEvent.NextLevel);
            });
        })

    }
  }

  onDestroy() {
    super.onDestroy();
    Tween.removeTweens(this.A);
    Tween.removeTweens(this.B);
    Tween.removeTweens(this.right);
    this.A.off("globalpointermove", this.onAPointerMove, this);
  }

}
