import React from "react";
import { observer } from "mobx-react";
import { preload } from "@/core/preload.ts";
import styles from "./LoadingDemo.module.less";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import HomePage from "@/pages/HomePage/HomePage.tsx";
import { Assets } from "pixi.js";

@observer
class LoadingDemo extends React.Component {

  state = {
    curPercentage: 0
  }

  async componentDidMount() {
    this.preloadAssetInit();
  }

  /**
   * 资源预加载
   */
  preloadAssetInit = async () => {

    // const files = import.meta.glob("../../assets/**/*", {
    //   import: "default",
    //   eager: true,
    // });

    // 安全加载资源，明确列出需要加载的文件
    const assetFiles = [
      // Common assets
      "../../assets/common/banner.png",
      "../../assets/common/close.png",
      "../../assets/common/music_close.png",
      "../../assets/common/music_open.png",
      "../../assets/common/返回.png",
      
      // HomePage assets (排除有问题的?.png文件)
      "../../assets/HomePage/Qg.png",
      "../../assets/HomePage/answer.png",
      "../../assets/HomePage/assist.png",
      // 添加其他确需加载的HomePage资源
      "../../assets/HomePage/bg.jpg",
      "../../assets/HomePage/bg.png",
      "../../assets/HomePage/book.png",
      // 继续添加其他必要的资源路径...
    ];

    const urls = await Promise.all(
      assetFiles.map(path => import(path).then(m => m.default))
    );

    await preload(urls, (progress, loaded, total) => {
      const percentage = progress;
      this.setEvenProgress(percentage);
    });

    this.setEvenProgress(1);

    setTimeout(() => {
      PageCtrl.changePage(HomePage); // 跳转页面
    }, 100);
  };

  /**
   * 以1%匀速加载进度
   * @param {*} percentage
   */
  setEvenProgress = (percentage: number) => {
    this.setState({
      curPercentage: percentage,
    });
  };

  render() {
    const { curPercentage } = this.state;

    return <>
      <div className={styles.loading}>
        <div className={styles.bg}/>
        <div className={styles.progressBarBg}/>
        <div className={styles.progressBarFill} style={{
          width: `${curPercentage * 4.7}rem`
        }}/>
        {/*<span className="progressTxt">金豆正在路上...... {curPercentage}%</span>*/}
      </div>
      <div className={styles.title}/>
    </>;
  }
}

export default LoadingDemo;
