'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './homepage.less';
import { Button, Toast } from '@grace/ui';
import { _asyncThrottle } from "../../utils/utils";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import Rulepop from "../../components/rulepop/rulepop.jsx";
import DrawPage from "../DrawPage/DrawPage.jsx";
import store from '@/store/store';
import Taskpop from '@/panels/taskpop/taskpop.js';
import RankPage from '../RankPage/RankPage.js';
import MyPrize from '../MyPrize/MyPrize.js';


@observer
class Homepage extends React.Component {
  constructor(props) {
    super(props);

    this.handleButtonClick = this.handleButtonClick.bind(this);
  }

  componentDidMount() {
    store.updateIndex()
  }

  handleButtonClick = _asyncThrottle(async (number) => {
    // 活动时间判断
    // 规则 奖品始终可以点击 我的排名结束可以点击 其余常规逻辑
    if (!(number === 0 || number === 4 || number === 5)) {
      if ((!store.judgeActTime(true, true))) return;
    }
    if ((number === 0)) {
      if ((!store.judgeActTime(true, false))) return;
    }
    switch (number) {
      // 0 我的排名
      case 0:
        // TODO 换成我的排名页面 记得引用
        // PageCtrl.changePage(); 
        break;

      // 1 抽奖
      case 1:
        PageCtrl.changePage(DrawPage);
        break;

      // 2 做任务
      case 2:
        // TODO
        ModalCtrl.showModal(Taskpop);
        break;

      // 3 答题
      case 3:
        // TODO
        break;

      // 4 我的奖品
      case 4:
        // TODO 换成我的奖品页面 记得引用
        PageCtrl.changePage(MyPrize);
        break;

      // 5 活动规则
      case 5:
        ModalCtrl.showModal(Rulepop);
        break;

      // 6 拜访清单
      case 6:
        // TODO
        break;

      // 7 分享活动
      case 7:
        // TODO
        break;

      default:
        console.warn("未知按钮类型", number);
    }
  })

  render() {
    return (
      <div className="homepage modal_center">
        <span className="bg"></span>
        <span className="equipment"></span>
        <span className="icon"></span>
        <span className="book"></span>
        <span className="brain"></span>
        <span className="wenhao"></span>
        <span className="title"></span>
        {/* 按钮 共7个 */}
        <div className="rank">
          <span className="r_bg"></span>
          <span className="name">用户uid:132802</span>
          <span className="head"></span>
          <Button className="myrank" onClick={() => this.handleButtonClick(0)} />
          <span className="number">000</span>
        </div>
        <span className="logo"></span>
        <Button className="draw" onClick={() => this.handleButtonClick(1)} />
        <Button className="task" onClick={() => this.handleButtonClick(2)} />
        <Button className="matter" onClick={() => this.handleButtonClick(3)}>
          <span className="m_bg"></span>
          <span className="answer"></span>
          <span className="remain">剩余次数：3</span>
        </Button>
        <Button className="prize" onClick={() => this.handleButtonClick(4)} />
        <Button className="rule" onClick={() => this.handleButtonClick(5)} />
        <Button className="visit" onClick={() => this.handleButtonClick(6)} />
        <Button className="share" onClick={() => this.handleButtonClick(7)} />
      </div>
    );
  }
}
export default Homepage;