import { makeAutoObservable, } from 'mobx';
import { LevelArr } from "@/pages/GamePage/Level/LevelConfig.ts";
import API from "@/api";

class GameStore {

  constructor() {
    makeAutoObservable(this);
  }

  gameInfo = {
    levelIndex: -1,
    levelIdxArr: [],
    countdownSeconds: 180,
    remainTipTimes: 0,
  }

  async start() {

    const { success, data } = await API.start();
    if (!success) return false;

    this.gameInfo.levelIdxArr = LevelArr.map((_, index) => index);
    this.gameInfo.levelIdxArr.sort(() => Math.random() - 0.5);
    this.gameInfo.levelIndex = -1;
    this.gameInfo.countdownSeconds = data.countdownSeconds;
    this.gameInfo.remainTipTimes = data.remainTipTimes

    return success;
  }

  async submit() {

    const score = this.gameInfo.levelIndex;

  }
}

export default (new GameStore());
