import React, {Component} from 'react'
import {observer} from "mobx-react";
import {createRoot} from "react-dom/client";
import store from "./store/store";

import "./core/checkwebp.ts";
import "./MD";
import './App.less'
import '@csstools/normalize.css';

import musicStore from "@/store/musicStore.ts";
import {initWx} from "@/built-in/share/weixin/weixin.ts";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import { GetCurrSkinId, getCustomShareId, isMiniprogram } from "@/utils/utils.ts";

import MyPrize from "@/pages/MyPrize/MyPrize.tsx";
import LoadingDemo from "@/pages/LoadingDemo/LoadingDemo.tsx";

import GamePage from "@/pages/GamePage/GamePage.tsx";
import HomePage from './pages/HomePage/HomePage.tsx';
import AgentSharepage from './pages/agentSharepage/sharepage.jsx';
import SharePage from './pages/sharepage/sharepage.jsx';
import { onInitShare } from './utils/share.ts';
import { domain, ensureDomain } from "@spark/dbdomain";
import shareStore from './store/share.ts';


@observer
class App extends Component {

  showDefaultPage = () => {
    const skinId = GetCurrSkinId() || getCustomShareId();
    const defaultPage = {
      myPrize: MyPrize, // TODO 举例子 新宿台奖品页
      index: LoadingDemo,
      sharepage:SharePage,
    }[skinId] || GamePage;
    PageCtrl.changePage(defaultPage);
  }

  async componentDidMount() {
    this.showDefaultPage();

    await store.getFrontVariable();
    await onInitShare();
    await ensureDomain();
    CFG.domain = domain;
    if(isMiniprogram()){ //小程序域名写死
      CFG.domain = "https://96094-activity.dexfu.cn";
    }
    shareStore.initShare()
  }

  componentWillUnmount() {
  }

  render() {
    return <>
        <PageCtrl/>
        <ModalCtrl/>
    </>;
  }
}

const root = createRoot(document.getElementById('root')!);
root.render(
  <App/>
);

