import React, {Component} from 'react'
import {observer} from "mobx-react";
import {createRoot} from "react-dom/client";
import store from "./store/store";

import "./core/checkwebp.ts";
import "./MD";
import './App.less'
import '@csstools/normalize.css';

import musicStore from "@/store/musicStore.ts";
import {initWx} from "@/built-in/share/weixin/weixin.ts";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import { GetCurrSkinId, getCustomShareId, isMiniprogram, waitTime } from "@/utils/utils.ts";

import MyPrize from "@/pages/MyPrize/MyPrize.jsx";
import LoadingDemo from "@/pages/LoadingDemo/LoadingDemo.tsx";

import GamePage from "@/pages/GamePage/GamePage.tsx";
import HomePage from './pages/HomePage/HomePage.tsx';
import AgentSharepage from './pages/agentSharepage/sharepage.jsx';
import SharePage from './pages/sharepage/sharepage.jsx';
import { onInitShare } from './utils/share.js';
import { domain, ensureDomain } from "@spark/dbdomain";
import shareStore from './store/share.js';

import music from "../src/assets/audio/bgm.mp3";
// import * as eruda from "eruda";

// eruda.init({});

@observer
class App extends Component {

  showDefaultPage = () => {
    const skinId = GetCurrSkinId() || getCustomShareId();
    const defaultPage = {
      myPrize: MyPrize, // TODO 举例子 新宿台奖品页
      index: HomePage,
      sharepage:SharePage,
    }[skinId] || SharePage;
    PageCtrl.changePage(CFG.agentShare == "1" ?  AgentSharepage : defaultPage);
  }

  async componentDidMount() {
    const skinId = GetCurrSkinId() || getCustomShareId();
    console.info('skinId',skinId)
    if(CFG.agentShare != "1" && skinId == 'index'){
      musicStore.playSound( music, true);
    }

    this.showDefaultPage();
    await store.getFrontVariable();
    await onInitShare();
    await ensureDomain();
    CFG.domain = domain;
    if(isMiniprogram()){ //小程序域名写死
      CFG.domain = "https://96094-activity.dexfu.cn";
    }
    await waitTime(1)
    shareStore.initShare()
  }

  componentWillUnmount() {
  }

  render() {
    return <>
        <PageCtrl/>
        <ModalCtrl/>
    </>;
  }
}

const root = createRoot(document.getElementById('root')!);
root.render(
  <App/>
);

