import React from 'react';
import { observer } from 'mobx-react';
import './RankPage.less';
import API from "@/api";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import store from "@/store/store.ts";
import HomePage from '../HomePage/HomePage';

@observer
class RankPage extends React.Component<any, any> {

    clickBack = () => {
        PageCtrl.changePage(HomePage);
    }

    render() {
        return <div className="rankPage">
            <div className="bg"></div>
            <div className="title"></div>
            <div className="prizeList">
                <div className="prizeItem">
                    <div className="prizeImg">
                        <img src="" alt="" />
                    </div>
                    <div className="prizeName">奖品奖品奖品奖品奖品</div>
                    <div className="rank">第1名</div>                
                </div>
                
            </div>
            <div className="rankTitle">
                <div className="title1">排名</div>
                <div className="title2">用户昵称</div>
                <div className="title3">成功组局数/月</div>
            </div>
            <div className="myRankInfo">
                <div className="title1">999+</div>
                <div className="title2">用户昵称(我)</div>
                <div className="title3">20</div>
            </div>
            <div className="rankList">
                <div className="rankItem">
                    <div className="rank"><span></span></div>
                    <div className="name">11</div>
                    <div className="score">11</div>
                </div>
                <div className="rankItem">
                    <div className="rank"><span></span></div>
                    <div className="name">11</div>
                    <div className="score">11</div>
                </div>
                <div className="rankItem">
                    <div className="rank"><span></span></div>
                    <div className="name">11</div>
                    <div className="score">11</div>
                </div>
                <div className="rankItem">
                    <div className="rank">1</div>
                    <div className="name">11</div>
                    <div className="score">11</div>
                </div>
            </div>
            <span className="back" onClick={this.clickBack}></span>
        </div>;
    }
}

export default RankPage;