import React from 'react';
import { observer } from 'mobx-react';
import './RankPrizePop.less';
import API from "@/api";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import store from "@/store/store.ts";
import HomePage from '../../pages/HomePage/HomePage';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import { LOG_KEY, MatterShareOpt, MatterViewOpt, pageView, sensorLog,MatterViewDuration } from '../../utils/sensors.js';

@observer
class RankPrizePop extends React.Component<any, any> {

    componentDidMount(): void {
        pageView("b14288", {
            page_name: "排行榜中奖弹窗",
        });
    
        sensorLog(LOG_KEY.exposure, "b14288", "d14289", {
            page_name: "排行榜中奖弹窗",
            button_name: "开心收下按钮",
        });
    }
    clickBack = () => {
        ModalCtrl.closeModal();
    }
    clickBack2 = () => {
        sensorLog(LOG_KEY.click, "b14288", "d14289", {
            page_name: "排行榜中奖弹窗",
            button_name: "开心收下按钮",
        });
        ModalCtrl.closeModal();
    }

    render() {
       const { prize } = this.props;
        return <div className="rankPrizePop">
            <div className="light"></div>
            <div className="bg"></div>
            <div className="prizeImg">
                <img src={prize?.prizeImg} alt="" />
            </div>
            <div className="prizename">{prize?.prizeName}</div>
            <div className="btn"  onClick={this.clickBack2}></div>
            <span className="back" onClick={this.clickBack}></span>
        </div>;
    }
}

export default RankPrizePop;