import { LevelBase } from "@/pages/GamePage/Components/LevelBase.ts";
import { Assets, Rectangle, Sprite } from "pixi.js";
import { Ease, Tween } from "@/core/tween";
import { GameEvent, globalEvent } from "@/pages/GamePage/GameEvent.ts";

export class Level15 extends LevelBase {

  level: number = 15;

  A: Sprite;
  B: Sprite;
  C: Sprite;
  D: Sprite;
  mi: Sprite;
  mi2: Sprite;

  right: Sprite;
  error: Sprite;

  onLoad() {
    super.onLoad();

    this.D = this.addChild(new Sprite(Assets.get(`level${this.level}/D.png`)));
    this.D.position.set(460, 766);

    this.mi = this.addChild(new Sprite(Assets.get(`level${this.level}/mi.png`)));
    this.mi.position.set(129, 675);

    this.mi2 = this.addChild(new Sprite(Assets.get(`level${this.level}/mi2.png`)));
    this.mi2.position.set(129, 719);
    this.mi2.alpha = 0;

    const table = this.addChild(new Sprite(Assets.get(`level${this.level}/img.png`)));
    table.position.set(0, 665);
    table.interactive = false;
    table.eventMode = "none";

    this.A = this.addChild(new Sprite(Assets.get(`level${this.level}/A.png`)));
    this.A.position.set(78, 1169);

    this.B = this.addChild(new Sprite(Assets.get(`level${this.level}/B.png`)));
    this.B.position.set(311, 1159);

    this.C = this.addChild(new Sprite(Assets.get(`level${this.level}/C.png`)));
    this.C.position.set(495, 1149);

    this.right = this.addChild(new Sprite(Assets.get(`level${this.level}/right.png`)));
    this.right.position.set(146, 825);
    this.right.alpha = 0;
    this.right.interactive = false;
    this.right.eventMode = "none";

    this.error = this.addChild(new Sprite(Assets.get(`common/error.png`)));
    this.error.interactive = false;
    this.error.eventMode = "none";

    [this.D].forEach((item) => {
      item.on("pointerdown", this.onAPointerDown, this);
      item.on("pointerup", this.onAPointerUp, this);
      item.on("globalpointermove", this.onAPointerMove, this);
    });
    [this.A, this.B, this.C].forEach((item) => {
      item.on("pointertap", this.onTapOption.bind(this, item));
    });

  }


  onTapOption(item: Sprite) {
    this.setTouchEnable(false);
    const wait = 2000;

    this.error.visible = true;
    this.error.position.set(item.x + item.width - 30, item.y + item.height - 50);
    Tween.removeTweens(this.error);
    Tween.get(this.error)
      .wait(wait)
      .call(() => {
        this.error.visible = false;
        this.setTouchEnable(true);
      });
  }

  target: Sprite = null;
  pos: { x: number, y: number } = null;

  onAPointerUp(e) {
    this.pos = null;
    this.target = null;
  }

  onAPointerDown(e) {
    this.target = e.target;
    const { x, y } = e.data.global;
    this.pos = {
      x: x - e.target.x,
      y: y - e.target.y
    }
    this.addChild(e.target);
  }

  onAPointerMove(e) {
    if (!this.pos) return;
    const { x, y } = e.data.global;
    const nx = x - this.pos.x;
    const ny = y - this.pos.y;
    this.target.position.set(nx, ny);

    this.check();
  }

  check() {

    const { x: ax, y: ay, width: aw, height: ah } = this.target;

    const isIns = new Rectangle(ax + 60, ay, aw - 60, ah)
      .intersects(new Rectangle(180, 840, 37, 55));

    if (isIns) {
      this.setPauseCd(true);
      this.setTouchEnable(false);
      this.target.eventMode = "none";
      this.target.interactive = false;

      Tween.get(this.D).to({ x: 144, y: 824, width: 93, height: 96 }, 666, Ease.quadInOut);

      this.target = null;
      this.pos = null;

      Tween.get(this.D)
        .wait(666)
        .to({ alpha: 0 }, 666, Ease.quadInOut);

      Tween.get(this.mi)
        .wait(666)
        .to({ alpha: 0 }, 666, Ease.quadInOut);

      Tween.get(this.mi2)
        .wait(666)
        .to({ alpha: 1 }, 666, Ease.quadInOut);

      Tween.get(this.right)
        .wait(999)
        .to({ alpha: 1 }, 666, Ease.quadInOut)
        .wait(2000)
        .call(() => {
          globalEvent.emit(GameEvent.NextLevel);
        });

    }

  }

  onDestroy() {
    super.onDestroy();
    Tween.removeTweens(this.right);
    [this.A, this.B].forEach((item) => {
      item.off("globalpointermove", this.onAPointerMove, this);
    });
  }

}
