import { LevelBase } from "@/pages/GamePage/Components/LevelBase.ts";
import { Assets, Sprite } from "pixi.js";
import { Ease, Tween } from "@/core/tween";
import { GameEvent, globalEvent } from "@/pages/GamePage/GameEvent.ts";
import { errorWaitTime, rightWaitTime } from "@/pages/GamePage/Level/LevelConfig.ts";

export class Level14 extends LevelBase {

  level: number = 14;

  A: Sprite;
  B: Sprite;

  right: Sprite;
  error: Sprite;

  onLoad() {
    super.onLoad();

    this.addChild(new Sprite(Assets.get(`level${this.level}/img.png`)))
      .position.set(208, 656);

    this.B = this.addChild(new Sprite(Assets.get(`level${this.level}/B.png`)));
    this.B.position.set(510, 1007);

    this.A = this.addChild(new Sprite(Assets.get(`level${this.level}/A.png`)));
    this.A.position.set(117, 1035);

    this.right = this.addChild(new Sprite(Assets.get(`level${this.level}/right.png`)));
    this.right.position.set(208, 656);
    this.right.alpha = 0;
    this.right.interactive = false;
    this.right.eventMode = "none";

    this.error = this.addChild(new Sprite(Assets.get(`common/error.png`)));
    this.error.visible = false;
    this.error.interactive = false;

    [this.A, this.B]
      .forEach((item) => {
        item.on("pointertap", this.onTapOption.bind(this, item));
      });

    this.A.on("pointerdown", this.onAPointerDown, this);
    this.A.on("pointerup", this.onAPointerUp, this);
    this.A.on("globalpointermove", this.onAPointerMove, this);
  }

  onTapOption(item: Sprite) {
    this.pos = null;

    this.setTouchEnable(false);

    const dp = new Map([
      [this.A, { x: 110, y: 120 }],
      [this.B, { x: 100, y: 150 }],
    ]).get(item);

    console.log(dp)
    this.error.position.set(item.x + dp.x, item.y + dp.y);

    this.error.visible = true;
    Tween.removeTweens(this.error);
    Tween.get(this.error)
      .wait(errorWaitTime)
      .call(() => {
        this.error.visible = false;
        this.setTouchEnable(true);
      });
  }

  pos = null;

  onAPointerUp(e) {
    this.pos = null;
  }

  onAPointerDown(e) {
    const { x, y } = e.data.global;
    this.pos = {
      x: x - this.A.x,
      y: y - this.A.y
    }
  }

  onAPointerMove(e) {
    if (!this.pos) return;
    const { x, y } = e.data.global;
    const nx = x - this.pos.x;
    const ny = y - this.pos.y;
    this.A.position.set(nx, ny);

    if (
      nx >= 420
      && nx <= 540
      && ny >= 930
      && ny <= 1120
    ) {
      this.setPauseCd(true);
      this.setTouchEnable(false);
      Tween.get(this.A)
        .to({ x: 484, y: 1040 }, 444, Ease.quadInOut)
        .call(() => {
          Tween.get(this.right)
            .to({ alpha: 1 }, 444, Ease.quadInOut)
            .wait(rightWaitTime)
            .call(() => {
              globalEvent.emit(GameEvent.NextLevel);
            });
        })

    }
  }

  onDestroy() {
    super.onDestroy();
    Tween.removeTweens(this.A);
    Tween.removeTweens(this.error);
    Tween.removeTweens(this.right);
    this.A.off("globalpointermove", this.onAPointerMove, this);
  }

}
