import React from "react";
import {observer} from "mobx-react";
import "./TipPanel.less";
import {Button} from "@grace/ui";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";

export interface ITipPanelProps {
  tip: string;
}

@observer
class TipPanel extends React.Component<ITipPanelProps> {

  componentDidMount() {
  }

  clickClose = () => {
    ModalCtrl.closeModal();
  };

  clickBtn = () => {
    ModalCtrl.closeModal();
  };

  render() {
    const { tip } = this.props;

    return <div className="TipPanel modal_center">
      <div className="bg"/>
      <div className="text" dangerouslySetInnerHTML={{
        __html: tip,
      }}/>
      <Button className="btn md15" onClick={this.clickBtn}/>
      <Button className="close md16" onClick={this.clickClose}/>
    </div>;
  }
}

export default TipPanel;
