import React from "react";
import { observer } from "mobx-react";
import "./NoPrizeCard.less";
import { SvgaPlayer } from "@grace/svgaplayer";
import { Swiper, SwiperSlide } from "swiper/react";
import "swiper/css";
import { _throttle, randomNum } from "../../utils/utils";
import { Button } from "@grace/ui";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import { LOG_KEY, MatterShareOpt, MatterViewOpt, pageView, sensorLog,MatterViewDuration } from '../../utils/sensors.js';

import afterSvga from "../../assets/svga/7输出撕开.svga";

@observer
class NoPrizeCard extends React.Component {
  state = {
    card: true,
  };

  componentDidMount() {
    pageView("b14284", {
      page_name: "抽中未中奖弹窗",
    });
    sensorLog(LOG_KEY.exposure, "b14284", "d14285", {
      page_name: "抽中未中奖弹窗",
      button_name: "点击翻转按钮",
    });
    
  }

  /** card1文本选择 */
  opt1 = () => {
    const list = [
      "src/assets/NoPrizeCard/text1.png",
      "src/assets/NoPrizeCard/text2.png",
      "src/assets/NoPrizeCard/text3.png",
      "src/assets/NoPrizeCard/text4.png",
    ];
    const address = list[randomNum(0, 4)];
    return address;
  };

  /** 切换按钮*/
  clickExchange1 = () => {
    sensorLog(LOG_KEY.click, "b14284", "d14285", {
      page_name: "抽中未中奖弹窗",
      button_name: "点击翻转按钮",
    });
    this.setState({
      card: false,
      svg: true,
    });

    setTimeout(() => {
      this.setState({
        svg: false,
        card: false,
      });
    }, 2000);
  };

  /** 关闭按钮*/
  clickClose = _throttle(() => {
    ModalCtrl.closeModal();
  });

  render() {
    const { card } = this.state;
    const { productInfos } = this.props || {};
    console.log(productInfos);
    return (
      <div className="NoPrizeCard modal_center">
        {card === true ? (
          //翻转前
          <div className="card1">
            <span className="picture"></span>
            <img className="text" src={this.opt1()} />
          </div>
        ) : (
          //翻转后
          <div>
            <span className="afterBg"></span>
            <Swiper
              className="prodSwiper"
              indicatorProps={{ style: { display: "none" } }}
            >
              {productInfos?.map((item, index) => {
                return (
                  <SwiperSlide className="prodItem" key={index}>
                    <img
                      className="picture2"
                      src={item?.productImg}
                      alt={item?.productText}
                    />
                    <div className="txt">{item?.productText}</div>
                  </SwiperSlide>
                );
              })}
            </Swiper>
            {/* <Button className="exchange2" /> */}
            <SvgaPlayer className="after" src={afterSvga} loop={1} />
          </div>
        )}

        {card === true && (
          <Button className="exchange1 md26" onClick={this.clickExchange1} />
        )}

        <Button className="close" onClick={this.clickClose} />
      </div>
    );
  }
}

export default NoPrizeCard;
