import { LevelBase } from "@/pages/GamePage/Components/LevelBase.ts";
import { Assets, Sprite } from "pixi.js";
import { Tween } from "@/core/tween";
import { GameEvent, globalEvent } from "@/pages/GamePage/GameEvent.ts";

export class Level8 extends LevelBase {

  level: number = 8;

  A: Sprite;
  B: Sprite;
  C: Sprite;
  D: Sprite;

  right: Sprite;
  error: Sprite;

  onLoad() {
    super.onLoad();

    this.A = this.addChild(new Sprite(Assets.get(`level${this.level}/A.png`)));
    this.A.position.set(99, 724);

    this.B = this.addChild(new Sprite(Assets.get(`level${this.level}/B.png`)));
    this.B.position.set(398, 724);

    this.C = this.addChild(new Sprite(Assets.get(`level${this.level}/C.png`)));
    this.C.position.set(99, 1002);

    this.D = this.addChild(new Sprite(Assets.get(`level${this.level}/D.png`)));
    this.D.position.set(398, 1002);

    this.right = this.addChild(new Sprite(Assets.get(`level${this.level}/right.png`)));
    this.right.position.set(518, 530);
    this.right.visible = false;
    this.right.interactive = false;

    this.error = this.addChild(new Sprite(Assets.get(`level${this.level}/error.png`)));
    this.error.visible = false;
    this.error.interactive = false;

    [this.A, this.B, this.C, this.D, this.qs]
      .forEach((item) => {
        item.on("pointertap", this.onTapOption.bind(this, item));
      });

  }

  onTapOption(item: Sprite) {
    const isRight = item === this.qs;
    this.setTouchEnable(false);
    const dp = -10;
    const wait = 2000;

    if (isRight) {
      this.right.visible = true;
      Tween.get(this.error)
        .wait(wait)
        .call(() => {
          globalEvent.emit(GameEvent.NextLevel);
        });
    } else {
      this.error.visible = true;
      this.error.position.set(item.x + dp, item.y + dp);
      Tween.removeTweens(this.error);
      Tween.get(this.error)
        .wait(wait)
        .call(() => {
          this.error.visible = false;
          this.setTouchEnable(true);
        });
    }

  }

  onDestroy() {
    super.onDestroy();
    Tween.removeTweens(this.error);
  }

}
