import sensors from "sa-sdk-javascript/dist/web/sensorsdata.es6.js";
import SMEncryption from "sa-sdk-javascript/dist/web/plugin/sm-encryption/index.es6.js";
import { extranceName, platFormName, platformType } from "./constants.ts";
import { GetCurrSkinId } from "./utils";
import store from "@/store/store.ts";
const ENV = {
    test: "test",
    prod: "prod",
};

// todo 正式修改
const env = location.href.indexOf("duibatest") > -1 ? ENV.test : ENV.prod; // 测试
// const env = ENV.test; // 测试

/** 上报地址 */
const serverUrl = {
    [ENV.test]: "https://mdglfxpt-test.piccgroup.cn:18443/sa?project=picclife_consumer",
    [ENV.prod]: "https://mdglfxpt.piccgroup.cn:18443/sa?project=picclife_consumer",
};

/** 神策加密key */
const pub_key = {
    [ENV.test]:
        "04115969d70075438379dd348f650b4dcb27d0b12b92d9378b2b5d989b48dd9266d4654f08161cdb272b4c9069d64f77bb96fca6efcb1d1635bd7dcc36d058e07c",
    [ENV.prod]:
        "041717d6728d0f4efd409aeed420f64d3ef684d7e9d21b7b50cd427ce49c47c153916159009cd2f52039718a0e2ce3322cd954a0356c219effef262a5f1eddf8b3",
};
/** 人保加密 */
sensors.use(SMEncryption, {
    pkv: 2,
    pub_key: pub_key[env],
});

/** 渠道映射 */
export const CHANNEL_MAP = {
    1: "人保寿险管家app",
    2: "人保寿险企业家助手微信公众号",
    3: "友客微信公众号-精选专题",
    4: "e服务公众号",
    5: "友客小程序",
    6: "e通app",
    7: "微通",
    8: "友客-获客活动",
};

/** 埋点key */
export const LOG_KEY = {
    click: "click",
    exposure: "exposure",
    pageview: "pageview",
    result: "result",
    MatterView: "MatterView",
    MatterShare: "MatterShare",
    pageViewTime: "pageViewTime",
};

/** 埋点Event */
export const EVENT_NAME = {
    [LOG_KEY.click]: "actPageClick",
    [LOG_KEY.exposure]: "actPageExposure",
    [LOG_KEY.pageview]: "actPageView",
    [LOG_KEY.result]: "ActPageResult",
    [LOG_KEY.MatterView]: "MatterView",
    [LOG_KEY.MatterShare]: "MatterShare",
    [LOG_KEY.pageViewTime]: "MatterViewDuration"
};

let isInit = false;

/** 埋点事件 */
export const MD_EVENT = {
    PAGE_VIEW: "actPageExposure",
    PAGE_CLICK: "actPageClick",
};

export const initSensors = (uid) => {
    sensors.init({
        server_url: serverUrl[env],
        app_js_bridge: true,
        is_track_single_page: true,
        use_client_time: true,
        show_log: true,
        send_type: "beacon",
        heatmap: {
            clickmap: "default",
            scroll_notice_map: "not_collect",
        },
    });

    sensors.login(uid);
    const publicObjec = Object.assign(
        {
            currentUrl: location.href,
            referrer: document.referrer,
            theme_name: "非遗大冒险",
            act_name: "非遗大冒险",
            avtivity_name: "非遗大冒险",
            source_entry: CHANNEL_MAP[CFG.channel],
            source: CHANNEL_MAP[CFG.channel],
            platform_name: extranceName[CFG.channel],
            platform_type: platformType[CFG.channel],
            requirement_id: 1375,
            is_login: uid ? "是" : "否",
            operation_name: "非遗大冒险",
            source_platform: CHANNEL_MAP?.[CFG.channel] || CFG.channel,
            entrance: extranceName[CFG.channel],
        },
        window["__tbSensorsObj__"]
    );
    sensors.registerPage(publicObjec);
    sensors.quick("autoTrack");
    isInit = true;
};

/**
 *  真正的埋点 - 不区分曝光和点击，直接打
 * @param {string} eventName
 * @param {{page_name:string,button_name:string,operation_name:string}} options
 */
export const sensorLog = (logKey, bid, did, options) => {
    if (!isInit) {
        console.info(`%c 神策上报地址： ${serverUrl[env]} 当前环境： ${env}`, "font-size: 12px; color: green");
        const uid = store.homeInfo?.uid;
        initSensors(uid);
    }
    // console.log(`%c type: ${logKey}  track_sign: ${`aL06Activity.${bid}.${did}.${logKey}.${EVENT_NAME[logKey]}`}`, "font-size: 20px; color: rgb(244, 123, 93)");
    sensors.track(EVENT_NAME[logKey], {
        track_sign: `aL06Activity.${bid}.${did}.${logKey}.${EVENT_NAME[logKey]}`,
        avtivity_name: "非遗大冒险",
        operation_id: CFG.operationId,
        act_type: "客经",
        location_type: "活动",
        agent_code: store.homeInfo?.agentCode,
        act_id: CFG.actId,
        ...options
    });
};

export const pageViewD = (bid, did, options) => {
    if (!isInit) {
        console.info(`%c 神策上报地址： ${serverUrl[env]} 当前环境： ${env}`, "font-size: 12px; color: green");
        const uid = store.homeInfo?.uid;
        initSensors(uid);
    }
    // console.log(`%c type: ${logKey}  track_sign: ${`aL06Activity.${bid}.${did}.${logKey}.${EVENT_NAME[logKey]}`}`, "font-size: 20px; color: rgb(244, 123, 93)");
    sensors.track(EVENT_NAME[LOG_KEY.pageview], {
        track_sign: `aL06Activity.${bid}.${did}.${LOG_KEY.pageview}.${EVENT_NAME[LOG_KEY.pageview]}`,
        operation_id: CFG.operationId,
        avtivity_name: "非遗大冒险",
        act_type: "客经",
        location_type: "活动",
        agent_code: store.homeInfo?.agentCode,
        act_id: CFG.actId,
        ...options
    });
};

/**
 *  真正的埋点 - 不区分曝光和点击，直接打
 * @param {string} eventName
 * @param {{page_name:string,button_name:string,pop_name:string}} options
 */
export const pageView = (bid, options) => {
    if (!isInit) {
        console.info(`%c 神策上报地址： ${serverUrl[env]} 当前环境： ${env}`, "font-size: 12px; color: green");
        const uid = store.homeInfo?.uid;
        initSensors(uid);
    }
    // console.log(`%c type: ${logKey}  track_sign: ${`aL06Activity.${bid}.${did}.${logKey}.${EVENT_NAME[logKey]}`}`, "font-size: 20px; color: rgb(244, 123, 93)");
    sensors.track(EVENT_NAME[LOG_KEY.pageview], {
        track_sign: `aL06Activity.${bid}.${LOG_KEY.pageview}.${EVENT_NAME[LOG_KEY.pageview]}`,
        operation_id: CFG.operationId,
        avtivity_name: "非遗大冒险",
        act_type: "客经",
        location_type: "活动",
        agent_code: store.homeInfo?.agentCode,
        act_id: CFG.actId,
        ...options
    });
};

export const MatterViewOpt = (bid, options) => {
    if (!isInit) {
        console.info(`%c 神策上报地址： ${serverUrl[env]} 当前环境： ${env}`, "font-size: 12px; color: green");
        const uid = store.homeInfo?.uid;
        initSensors(uid);
    }
    sensors.track(EVENT_NAME[LOG_KEY.MatterView], {
        track_sign: `aL06Activity.${bid}.${LOG_KEY.pageview}.${EVENT_NAME[LOG_KEY.MatterView]}`,
        operation_id: CFG.operationId,
        agent_code: store.homeInfo?.agentCode,
        act_id: CFG.actId,
        act_type: "客经",
        location_type: "活动",
        entrance: extranceName[CFG.channel],
        sales_id: CFG.workerCode || store.homeInfo?.agentCode, // todo
        avtivity_name: "非遗大冒险",
        ...options
    });

};

export const MatterShareOpt = (bid, did, options) => {
    if (!isInit) {
        console.info(`%c 神策上报地址： ${serverUrl[env]} 当前环境： ${env}`, "font-size: 12px; color: green");
        const uid = store.homeInfo?.uid;
        initSensors(uid);
    }
    sensors.track(EVENT_NAME[LOG_KEY.MatterShare], {
        track_sign: `aL06Activity.${bid}.${did}.click.${EVENT_NAME[LOG_KEY.MatterShare]}`,
        operation_id: CFG.operationId,
        agent_code: store.homeInfo?.agentCode,
        act_id: CFG.actId,
        act_type: "客经",
        location_type: "活动",
        entrance: extranceName[CFG.channel],
        sales_id: CFG.workerCode || store.homeInfo?.agentCode, // todo
        avtivity_name: "非遗大冒险",
        ...options
    });

};

export const MatterViewDuration = (bid, time, options) => {
    if (!isInit) {
        console.info(`%c 神策上报地址： ${serverUrl[env]} 当前环境： ${env}`, "font-size: 12px; color: green");
        const uid = store.homeInfo?.uid;
        initSensors(uid);
    }
    sensors.track(EVENT_NAME[LOG_KEY.pageViewTime], {
        track_sign: `aL06Activity.${bid}.${LOG_KEY.pageViewTime}.${EVENT_NAME[LOG_KEY.pageViewTime]}`,
        operation_id: CFG.operationId,
        agent_code: store.homeInfo?.agentCode,
        act_id: CFG.actId,
        act_type: "客经",
        location_type: "活动",
        entrance: extranceName[CFG.channel],
        sales_id: CFG.workerCode || store.homeInfo?.agentCode, // todo
        avtivity_name: "非遗大冒险",
        $event_duration: time,
        ...options
    });

};