import { makeAutoObservable, } from 'mobx';
import API from '../api/index';
import { Toast } from "@grace/ui";
import { initWx, IWxShareInfo } from "@/built-in/share/weixin/weixin.ts";
import { _asyncThrottle, _debounce, getUrlParam } from '@/utils/utils';
// import { IBubbleInfo } from "@/pages/HomePage/Top/Components/Bubble.ts";
// import { IOverflowBubbleInfo } from "@/pages/HomePage/Top/Components/OverflowBubble.ts";
import { getDomain } from '@spark/dbdomain';
import { showShareGuide } from '@spark/share';

class Store {

  constructor() {
    makeAutoObservable(this);
  }

  baseInfo: any = {};

  /** 前端开发配置 */
  frontVariable: {
    shareInfo: any,
    ruleImg?: string,
  } = {
    shareInfo: {
      title: "",
      desc: "",
      imgUrl: "",
    },
  };

  ruleInfo = '';

  /** 积分门票 */
  ticketNum = null;

  /** 获取活动规则 */
  async initRule() {
    // 模拟获取远程的数据
    const { data } = await API.getRule();
    this.ruleInfo = data;
  }

  /** 获取前端配置项 */
  async getFrontVariable() {
    // 获取前端开发配置
    const { data } = await API.getFrontVariable();
    this.frontVariable = data || {};
    console.log('前端开发配置', data)
  }

  indexData: {
    actStartTime?: number,
    actEndTime?: number,
    currentTime?: number,

    guideFlag?: boolean,
    creditsNum?: number,
    expireDays?: number,
    currentStoreNum?: number,
    storeLimitNum?: number,
    continueSignDays?: number,
    todaySignFlag?: boolean,
    signRecords?: {
      id: string,
      day: number,
      creditsNum: number,
      boolSign: boolean,
    }[],

    // overflowBubble?: IOverflowBubbleInfo,

    // bubbleRecords?: IBubbleInfo[],

    returnAwardCreditsNum?: number,

    downGoldVo?: {
      creditsNum: number,
      multipleValue: number,
      taskId: string,
      url: string,
    },
    isAgent:string,

  } = {};
  firstIn = true;
  async updateIndex() {
    const { success, data } = await API.index();
    if (!success) {
      return;
    }
    this.indexData = data;

    /** 绑定业务员code判断 */
    if (data?.boundYkCode) {
      // 已绑定
      CFG.workerCode = data?.boundYkCode;
    } else {
      // 未绑定 从链接上取-无论是否有都要调用
      if (!data?.isAgent) {
        /**后端说增加非业务员才调用 */
        const res = await this.bindYkCode(CFG.workerCode || "");

        if (res.success && res.data?.code) {
          CFG.workerCode = res.data?.code;
        }
      }
    }

    if(this.firstIn && data.validUid){
      API.visit()
      this.firstIn = false
    }
  }

  /**
   * 更新首页信息，给倒计时用的
   */
  updateIndexThrottle = _debounce(async () => {
    return await this.updateIndex();
  }, 500);

  // 活动时间拦截
  // 结束不拦截 brakeEnd为false
  // 规则奖品始终可以点击 不用调方法 
  judgeActTime(brakeStart = true, brakeEnd = true) {
    if (brakeStart && this.indexData.currentTime < this.indexData.actStartTime) {
      Toast.show("活动未开始");
      return false
    } else if (brakeEnd && this.indexData.currentTime > this.indexData.actEndTime) {
      Toast.show("活动已结束");
      return false
    }
    return true;
  }


  async bindYkCode(code) {
    const res = await API.bindYk({
      code: code,
    });
    return res;
  }
}

export default (new Store());
