'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './sharepage.less';
import { _throttle, getUrlParam, windowJumpUrl } from '@/utils/utils.ts';
// import { accessLog } from 'duiba-utils';
// import store from '@/store';
import API from '@/api';
import { extranceName } from '@/utils/constants.ts';
// import { handleLogClick, handleLogExposure } from '../../../MD';
import shareStore from '@/store/share.ts';
// import { LOG_KEY, MatterShareOpt, MatterViewDuration, MatterViewOpt, sensorLog } from '@src/utils/sensors';

@observer
class AgentSharepage extends React.Component {
  constructor(props) {
    super(props);

    this.state = {
      shareInfo: {}
    }
    this.startTime = +new Date();
    this.shareRef = null;
  }

  async componentDidMount() {

    // MatterViewOpt("b13548", {
    //   page_name: "非遗-落地页",
    // });

    // sensorLog(LOG_KEY.exposure, "b13548", "d13549", {
    //   page_name: "非遗-落地页",
    //   button_name: "分享活动按钮",
    // });
    // await store.checkBindStatus();
    // await this.getShareInfo();

    if (getUrlParam("inviteCode")) {
      // handleLogExposure(13)
    } else {
      // handleLogExposure(20)
    }
    // setTimeout(() => {
    //   this.shareRef.scrollTo(0, 70)
    // }, 50)
  }

  componentWillUnmount() {
    // MatterViewDuration("b13548", +new Date() - this.startTime, {
    //   page_name: "非遗-落地页",
    // });

  }

  getShareInfo = async () => {
    const { success, data } = await API.coop_getLoadingInfo();
    if (success && data) {
      this.setState({
        shareInfo: data
      })
    }
  }

  /** 跳转微信端活动 */
  toWeActHandle = () => {
    if (getUrlParam("inviteCode")) {
      // handleLogClick(13)
    } else {
      // handleLogClick(20)
    }
    CFG.workerCode = getUrlParam("ykCode");
    let url = CFG.domain + CFG.indexUrl + '&channel=' + CFG.channel + `${!!getUrlParam("inviteCode") ? ("&inviteCode=" + getUrlParam("inviteCode")) : ""}` + `${!!CFG.workerCode ? `&ykCode=${CFG.workerCode}` : ""}`
    location.href = url
  }

  handleShareAct = _throttle(() => {
    // MatterShareOpt("b13548", "d13549", {
    //   button_name: "分享活动按钮",
    //   page_name: "非遗-落地页",
    //   entrance: extranceName[CFG.channel],
    // })

    console.log("share")
    shareStore.doShare()
  })

  render() {
    // const { actStartTimestamp, actEndTimestamp } = this.state?.shareInfo || {};
    return (
      <div className="agentsharepage_wrap" ref={r => this.shareRef = r}>
        <div className="sharepage modal_center">
          <span className="bg"></span>
          <span className="normal_btn md53" onClick={this.handleShareAct}></span>
        </div>
      </div>
    );
  }
}
export default AgentSharepage;
