"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./sharepage.less";
import { dateFormatter, getUrlParam, isMiniprogram, windowJumpUrl } from "@/utils/utils.ts";
// import { accessLog } from "duiba-utils";
import store from "@/store/store.ts";
import API from "@/api";
// import { PAGE_MAP } from "@src/utils/constants";
// import modalStore from "@src/store/modal";
// import { handleLogClick, handleLogExposure } from "../../../MD";
import { LOG_KEY, MatterViewDuration, MatterViewOpt, sensorLog } from "../../utils/sensors.js";

@observer
class Sharepage extends React.Component {
  constructor(props) {
    super(props);

    this.state = {
      shareInfo: {},
    };

    this.startTime = +new Date();
    this.shareRef = null;
  }

  async componentDidMount() {
    // accessLog(506)
    // await store.checkBindStatus();
    await this.getShareInfo();
    MatterViewOpt("b14316", {
      page_name: "落地页",
    });
    sensorLog(LOG_KEY.exposure, "b14316", "d14319", {
      page_name: "落地页",
      button_name: "进入活动按钮",
    });
    sensorLog(LOG_KEY.exposure, "b14316", "d14318", {
      page_name: "落地页",
      button_name: "为TA助力按钮",
    });


    

    if (getUrlParam("inviteCode")) {
      // handleLogExposure(13)
    } else {
      // handleLogExposure(20)
    }
    // setTimeout(() => {
    //   this.shareRef.scrollTo(0, 70)
    // }, 50)
  }

  componentWillUnmount() {

  }

  getShareInfo = async () => {
    const { success, data } = await API.coop_getLoadingInfo();
    if (success && data) {
      this.setState({
        shareInfo: data,
      });
    }
    // if (!data?.validUid) {
    //   modalStore.pushPop("Loginpop")
    // }
  };

  /** 跳转微信端活动 */
  toWeActHandle = () => {

    console.warn("toWeActHandle")


    if (getUrlParam("inviteCode")) {
      // handleLogClick(13)
      sensorLog(LOG_KEY.click, "b14316", "d14318", {
        page_name: "落地页",
        button_name: "为TA助力按钮",
      });
    } else {
      sensorLog(LOG_KEY.click, "b14316", "d14319", {
        page_name: "落地页",
        button_name: "进入活动按钮",
      });
      // handleLogClick(20)
    }
    CFG.workerCode = getUrlParam("ykCode");
    if (isMiniprogram()) { //小程序域名写死
      CFG.domain = "https://96094-activity.dexfu.cn";
    } else {
      CFG.domain = location.origin
    }
    let url =
      CFG.domain +
      CFG.indexUrl +
      "&channel=" +
      CFG.channel +
      `${!!getUrlParam("inviteCode") ? "&inviteCode=" + getUrlParam("inviteCode") : ""}` +
      `${!!CFG.workerCode ? `&ykCode=${CFG.workerCode}` : ""}` +
      `&agentCode=${CFG.agentCode || ""}&actPlatforms=${CFG.actPlatforms || ""}&actId=${CFG.actId || ""}`;
    // alert(url)
    // MatterViewDuration("b13548", +new Date() - this.startTime, {
    //   page_name: "非遗-落地页",
    // });
    setTimeout(() => {
      location.href = url;
    }, 500)
  };

  render() {
    const { actStartTimestamp, actEndTimestamp } = this.state?.shareInfo || {};
    return (
      <div className="sharepage_wrap" ref={(r) => (this.shareRef = r)}>
        <div className="sharepage modal_center">
          <span className="bg"></span>
          {/* <span className="time">
            活动时间：{dateFormatter(actStartTimestamp, "yyyy年MM月dd日")}-{dateFormatter(actEndTimestamp, "MM月dd日")}
          </span> */}
          {
            getUrlParam("inviteCode") && <div className="tips"></div>
          }
          {getUrlParam("inviteCode") ? <span className="assist_btn md55"></span> : <span className="normal_btn md54"></span>}
          <span className="click_area" onClick={() => this.toWeActHandle()}></span>
        </div>
      </div>
    );
  }
}
export default Sharepage;
