"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./prizepop.less";
import { Button } from "@grace/ui";
import { _asyncThrottle } from "../../utils/utils";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import { LOG_KEY, MatterShareOpt, MatterViewOpt, pageView, sensorLog,MatterViewDuration } from '../../utils/sensors.js';

@observer
class Prizepop extends React.Component {
  constructor(props) {
    super(props);
  }
  componentDidMount(){
    pageView("b14281", {
      page_name: "抽中中奖弹窗",
    });

    sensorLog(LOG_KEY.exposure, "b14281", "d14283", {
        page_name: "抽中中奖弹窗",
        button_name: "开心收下按钮",
    });
  }

  handleReceive = _asyncThrottle(() => {
    sensorLog(LOG_KEY.click, "b14281", "d14283", {
        page_name: "抽中中奖弹窗",
        button_name: "开心收下按钮",
    });
    ModalCtrl.closeModal()
  })

  handleClose = _asyncThrottle(() => {
    ModalCtrl.closeModal()
  })
  
  render() {
    const { prizeInfo } = this.props || {};
    const { prizeName = "", prizeImg = "" } = prizeInfo;
    return (
      <div className="prizepop modal_center">
        <span className="light"></span>
        <span className="bg"></span>
        <Button className="receive" onClick={this.handleReceive} />
        <img className="icon" src={prizeImg} alt={prizeName} />
        <span className="name">{prizeName}</span>
        <span className="tip">奖品可在首页 我的奖品 中查看</span>
        <span className="title"></span>
        <Button className="close" onClick={this.handleClose} />
      </div>
    );
  }
}
export default Prizepop;
