import { LevelBase } from "@/pages/GamePage/Components/LevelBase.ts";
import { Assets, Sprite } from "pixi.js";
import { Tween } from "@/core/tween";
import { GameEvent, globalEvent } from "@/pages/GamePage/GameEvent.ts";
import { errorWaitTime, rightWaitTime } from "@/pages/GamePage/Level/LevelConfig.ts";

export class Level1 extends LevelBase {

  level: number = 1;

  A: Sprite;
  B: Sprite;
  C: Sprite;
  D: Sprite;

  right: Sprite;
  error: Sprite;

  onLoad() {
    super.onLoad();

    this.A = this.addChild(new Sprite(Assets.get(`level${this.level}/A.png`)));
    this.A.position.set(99, 724);

    this.B = this.addChild(new Sprite(Assets.get(`level${this.level}/B.png`)));
    this.B.position.set(398, 724);

    this.C = this.addChild(new Sprite(Assets.get(`level${this.level}/C.png`)));
    this.C.position.set(99, 1002);

    this.D = this.addChild(new Sprite(Assets.get(`level${this.level}/D.png`)));
    this.D.position.set(398, 1002);

    this.right = this.addChild(new Sprite(Assets.get(`level${this.level}/right.png`)));
    this.right.visible = false;
    this.right.interactive = false;

    this.error = this.addChild(new Sprite(Assets.get(`level${this.level}/error.png`)));
    this.error.visible = false;
    this.error.interactive = false;

    [this.A, this.B, this.C, this.D]
      .forEach((item) => {
        item.on("pointertap", this.onTapOption.bind(this, item));
      });

  }

  onTapOption(item: Sprite) {
    const isRight = item === this.C;
    this.setTouchEnable(false);
    const dp = -10;

    if (isRight) {
      this.setPauseCd(true);
      this.right.visible = true;
      this.right.position.set(item.x + dp, item.y + dp);
      Tween.get(this.right)
        .wait(rightWaitTime)
        .call(() => {
          globalEvent.emit(GameEvent.NextLevel);
        });
    } else {
      this.error.visible = true;
      this.error.position.set(item.x + dp, item.y + dp);
      Tween.removeTweens(this.error);
      Tween.get(this.error)
        .wait(errorWaitTime)
        .call(() => {
          this.error.visible = false;
          this.setTouchEnable(true);
        });
    }

  }

  onDestroy() {
    super.onDestroy();
    Tween.removeTweens(this.right);
    Tween.removeTweens(this.error);
  }

}
