import { Assets, PointData, Sprite, Ticker } from "pixi.js";
import 'pixi.js/math-extras';
import { Base } from "@/core/pixi/base/Base.ts";
import { observer, reactor } from "./mobx/decorators.ts";
import { GameEvent, globalEvent } from "./GameEvent.ts";
import { Level1 } from "@/pages/GamePage/Level/Level1.ts";
import { Level2 } from "@/pages/GamePage/Level/Level2.ts";
import { Level3 } from "@/pages/GamePage/Level/Level3.ts";
import { Level4 } from "@/pages/GamePage/Level/Level4.ts";
import { Level5 } from "@/pages/GamePage/Level/Level5.ts";
import { Level6 } from "@/pages/GamePage/Level/Level6.ts";
import { Level7 } from "@/pages/GamePage/Level/Level7.ts";
import { Level8 } from "@/pages/GamePage/Level/Level8.ts";
import { Level9 } from "@/pages/GamePage/Level/Level9.ts";
import { Level10 } from "@/pages/GamePage/Level/Level10.ts";
import { Level11 } from "@/pages/GamePage/Level/Level11.ts";
import { Level12 } from "@/pages/GamePage/Level/Level12.ts";
import { Level13 } from "@/pages/GamePage/Level/Level13.ts";
import { Level14 } from "@/pages/GamePage/Level/Level14.ts";
import { Level15 } from "@/pages/GamePage/Level/Level15.ts";
import { Level18 } from "@/pages/GamePage/Level/Level18.ts";
import { Level19 } from "@/pages/GamePage/Level/Level19.ts";
import { Level20 } from "@/pages/GamePage/Level/Level20.ts";
import { Level21 } from "@/pages/GamePage/Level/Level21.ts";
import { Level22 } from "@/pages/GamePage/Level/Level22.ts";
import { Level23 } from "@/pages/GamePage/Level/Level23.ts";
import { Level24 } from "@/pages/GamePage/Level/Level24.ts";
import gameStore from "@/store/gameStore.ts";
import { LevelArr } from "@/pages/GamePage/Level/LevelConfig.ts";
import { LevelBase } from "@/pages/GamePage/Components/LevelBase.ts";
import { Level16 } from "./Level/Level16.ts";
import { Level17 } from "./Level/Level17.ts";
import { Level25 } from "./Level/Level25.ts";

@observer
export class Game extends Base {

  level: LevelBase = null;

  pauseCd: boolean = false;

  setPauseCd = (pause: boolean) => {
    this.pauseCd = pause;
  };


  onLoad() {
    const qsBg = this.addChild(new Sprite(Assets.get("问题.png")));
    qsBg.position.set(49, 316);

    // this.level = this.addChild(new Level19(this.setPauseCd));
    globalEvent.on(GameEvent.NextLevel, this.nextLevel, this);

    this.nextLevel();
    this.startCd();
  }


  gameOver() {
    this.eventMode = "none";
    this.interactive = this.interactiveChildren = false;

    gameStore.submit(gameStore.gameInfo.levelIndex);
  }

  intervalId: number = null;

  startCd() {
    this.intervalId = window.setInterval(() => {
      if (this.pauseCd) return;
      const newCd = gameStore.gameInfo.cd -= 1;
      if (newCd <= 0) {
        clearInterval(this.intervalId);
        this.gameOver();
        return;
      }
    }, 1000);
  }

  nextLevel() {
    gameStore.gameInfo.levelIndex++;

    const { levelIndex, levelIdxArr } = gameStore.gameInfo;

    if (levelIndex > 0) {
      if (levelIndex >= LevelArr.length) {
        this.setPauseCd(true);
        clearInterval(this.intervalId);
        gameStore.middleSubmit(levelIndex);
        gameStore.submit(LevelArr.length);
        return;
      } else {
        gameStore.gameInfo.cd = gameStore.gameInfo.countdownSeconds;
        this.setPauseCd(false);
        gameStore.middleSubmit(levelIndex);
      }
    } else {
      gameStore.gameInfo.cd = gameStore.gameInfo.countdownSeconds;
    }

    if (levelIndex >= levelIdxArr.length) {
      return;
    }

    const levelIdx = levelIdxArr[levelIndex];

    if (this.level) {
      this.level.removeFromParent();
      this.level.destroy();
    }

    const { cls } = LevelArr[levelIdx];

    this.level = this.addChild(new cls(this.setPauseCd));
    // this.level = this.addChild(new Level25());
  }

  receiveEffect(point: PointData) {

  }

  onUpdate(time: Ticker) {
    // const dt = time.deltaMS / 1000;
  }

  onDestroy() {
    super.onDestroy();
    clearInterval(this.intervalId);
    globalEvent.off(GameEvent.NextLevel, this.nextLevel, this);
  }
}
