import { LevelBase } from "@/pages/GamePage/Components/LevelBase.ts";
import { Assets, Sprite } from "pixi.js";

export class Level3 extends LevelBase {

  level: number = 3;

  A: Sprite;
  B: Sprite;
  C: Sprite;
  D: Sprite;

  right: Sprite;
  error: Sprite;

  onLoad() {
    super.onLoad();

    this.A = this.addChild(new Sprite(Assets.get(`level${this.level}/A.png`)));
    this.A.position.set(100, 724);

    this.B = this.addChild(new Sprite(Assets.get(`level${this.level}/B.png`)));
    this.B.position.set(398, 724);

    this.C = this.addChild(new Sprite(Assets.get(`level${this.level}/C.png`)));
    this.C.position.set(100, 1002);

    this.D = this.addChild(new Sprite(Assets.get(`level${this.level}/D.png`)));
    this.D.position.set(398, 1002);

    this.right = this.addChild(new Sprite(Assets.get(`level${this.level}/right.png`)));
    this.right.visible = false;
    this.right.interactive = false;

    this.error = this.addChild(new Sprite(Assets.get(`level${this.level}/error.png`)));
    this.error.visible = false;
    this.error.interactive = false;

    [this.A, this.B, this.C, this.D]
      .forEach((item) => {
        item.on("pointertap", this.onTapOption.bind(this, item));
      });

  }

  onTapOption(item: Sprite) {
    const isRight = item === this.A;
    this.right.visible = isRight;
    this.error.visible = !isRight;

    const dp = -10;

    this.right.position.set(item.x + dp, item.y + dp);
    this.error.position.set(item.x + dp, item.y + dp);

  }

}
