import { LevelBase } from "@/pages/GamePage/Components/LevelBase.ts";
import { Assets, Sprite } from "pixi.js";
import { Ease, Tween } from "@/core/tween";
import { GameEvent, globalEvent } from "@/pages/GamePage/GameEvent.ts";

export class Level10 extends LevelBase {

  level: number = 10;

  A: Sprite;
  B: Sprite;
  D: Sprite;

  right: Sprite;
  error: Sprite;

  onLoad() {
    super.onLoad();

    this.addChild(new Sprite(Assets.get(`level${this.level}/C.png`)))
      .position.set(207, 902);

    this.B = this.addChild(new Sprite(Assets.get(`level${this.level}/B.png`)));
    this.B.position.set(136, 913);

    this.D = this.addChild(new Sprite(Assets.get(`level${this.level}/D.png`)));
    this.D.position.set(629, 900);

    this.A = this.addChild(new Sprite(Assets.get(`level${this.level}/A.png`)));
    this.A.position.set(81, 903);

    this.right = this.addChild(new Sprite(Assets.get(`common/right.png`)));
    this.right.position.set(656, 1002);
    this.right.alpha = 0;
    this.right.interactive = false;
    this.right.eventMode = "none";

    this.A.on("pointerdown", this.onAPointerDown, this);
    this.A.on("pointerup", this.onAPointerUp, this);
    this.A.on("globalpointermove", this.onAPointerMove, this);
  }

  pos = null;

  onAPointerUp(e) {
    this.pos = null;
  }

  onAPointerDown(e) {
    const { x, y } = e.data.global;
    this.pos = {
      x: x - this.A.x,
      y: y - this.A.y
    }
  }

  onAPointerMove(e) {
    if (!this.pos) return;
    const { x, y } = e.data.global;
    const nx = x - this.pos.x;
    const ny = y - this.pos.y;
    this.A.position.set(nx, ny);

    if (
      nx >= 605
      && nx <= 650
      && ny >= 865
      && ny <= 940
    ) {
      this.setPauseCd(true);
      this.setTouchEnable(false);
      Tween.get(this.B).to({ alpha: 0 }, 444, Ease.quadInOut);
      Tween.get(this.D).to({ alpha: 0 }, 444, Ease.quadInOut);
      Tween.get(this.A)
        .to({ x: 637, y: 903 }, 444, Ease.quadInOut)
        .call(() => {
          Tween.get(this.right)
            .to({ alpha: 1 }, 444, Ease.quadInOut)
            .wait(2000)
            .call(() => {
              globalEvent.emit(GameEvent.NextLevel);
            });
        })

    }
  }

  onDestroy() {
    super.onDestroy();
    Tween.removeTweens(this.A);
    Tween.removeTweens(this.B);
    Tween.removeTweens(this.D);
    Tween.removeTweens(this.right);
    this.A.off("globalpointermove", this.onAPointerMove, this);
  }

}
