"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./mappage.less";
import { dateFormatter, getUrlParam, isMiniprogram, windowJumpUrl } from "@/utils/utils.ts";
// import { accessLog } from "duiba-utils";
import store from "@/store/store.ts";
import API from "@/api";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import HomePage from '../HomePage/HomePage.tsx';
import { handleLogClick, handleLogExposure } from "../../MD.js";
import { LOG_KEY, MatterViewDuration, MatterViewOpt, sensorLog } from "../../utils/sensors.js";
import { _throttle } from "@/utils/utils.js";
import { Button, Toast } from "@grace/ui";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import MapInfoPopup from '@/panels/MapInfoPopup/index.jsx'
//研学地图页面+地图详情

const cities = [
  { spId: 'sp_landmark1', name: '北京' },
  { spId: 'sp_landmark2', name: '西安' },
  { spId: 'sp_landmark3', name: '上海' },
  { spId: 'sp_landmark4', name: '杭州' },
  { spId: 'sp_landmark5', name: '成都' }
];

@observer
class Mappage extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      spInfoList: []
    };
  }

  componentDidMount() {
    this.getMapInfo();

  }
  getMapInfo = async () => {

    let res = await API.mapInfo();
    // res = {
    //   "success": true,
    //   "code": "",
    //   "message": "",
    //   "data": {
    //     "spInfoList": [
    //       {
    //         "spId": "sp_landmark1",
    //         "name": "北京",
    //         "icon": "https://www.baidu.com/tiananmen.png",
    //         "unlockFlag": true
    //       },
    //       {
    //         "spId": "sp_landmark2",
    //         "name": "上海",
    //         "icon": "https://www.baidu.com/dongfangmingzhu.png",
    //         "unlockFlag": false
    //       },
    //       {
    //         "spId": "sp_landmark3",
    //         "name": "广州",
    //         "icon": "https://www.baidu.com/guangzhouta.png",
    //         "unlockFlag": false
    //       },
    //       {
    //         "spId": "sp_landmark4",
    //         "name": "深圳",
    //         "icon": "https://www.baidu.com/shenzhendiwangdasha.png",
    //         "unlockFlag": true
    //       },
    //       {
    //         "spId": "sp_landmark5",
    //         "name": "杭州",
    //         "icon": "https://www.baidu.com/hangzhoudasha.png",
    //         "unlockFlag": false
    //       }
    //     ]
    //   }
    // }
    console.log('res:::::', res);
    if (res?.success) {
      this.setState({
        spInfoList: res.data.spInfoList
      })
    }
  }

  onBack = () => {
    PageCtrl.changePage(HomePage);
  }

  onSee = (spId) => {
    const { spInfoList } = this.state;
    const targetCity = spInfoList.find(city => city.spId === spId);
    if (!targetCity.unlockFlag) {
      Toast.show("当前城市未解锁，快去参与游戏解锁吧~");
      return;
    }
    console.log('查看:', spId)
    ModalCtrl.showModal(MapInfoPopup, {spId: spId});
  }

  render() {
    const { spInfoList } = this.state;
    return (
      <div className="Mappage">
        <div className="map_bg">
          <div className="back_btn md28" onClick={this.onBack}></div>
          <div className="map_title"></div>
          <div className="city_box">
            {spInfoList.map((city, index) => (
              <div key={index} className="city_card">
                <div className={city.unlockFlag ? "city_icon city_icon_" + city.spId : "city_icon city_icon_lock_" + city.spId}>
                </div>
                <div className="city_overlay">
                  <div className="city_name">{city.name}</div>
                  <div className={city.unlockFlag ? 'see_btn md29' : 'lock_see_btn md29'} onClick={() => this.onSee(city.spId)}></div>
                </div>
              </div>
            ))}
          </div>
        </div>
      </div >
    );
  }
}
export default Mappage;
