import React from 'react';
import { observer } from 'mobx-react';
import store from "@/store/store.ts";

import styles from "./GamePage.module.less";
import { Application, Assets, Sprite, Ticker } from "pixi.js";
import { initBundle } from "@/core/pixi/Helper.ts";
import { Tween } from "@/core/tween";
import "@/core/pixi/base/mix.ts";

import { initDevtools } from '@pixi/devtools';
import { Button } from "@grace/ui";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import gameStore from "@/store/gameStore.ts";

import.meta.env.DEV && initDevtools({});

import { _throttle } from "@/utils/utils.ts";
import { GameEvent, globalEvent } from "@/pages/GamePage/GameEvent.ts";
import { LOG_KEY, pageView, sensorLog } from "@/utils/sensors";


import "./js/output";
import API from '@/api';
import { handleLogClick, handleLogExposure } from '@/MD';
import Homepage from '../HomePage/HomePage';

declare const Game: any;

@observer
class GamePage extends React.Component<any, any> {

  gameCanvas: HTMLCanvasElement = null;
  gameDiv: HTMLDivElement = null;
  app: Application = null;
  game = null;

  async componentDidMount() {
    // import { Game } from "./output.js" |  window[Game]
    //实例，传入资源路径
    // const store.game = this.store.game = new Game("./released/resource/")
    // https://yun.duiba.com.cn/db_games/RB_yanxue/250620/index.html
    store.game = this.game = new Game("https://yun.duiba.com.cn/db_games/RB_yanxue/250620/resource/")
    //可预加载资源
    store.game.preLoad();
    //初始化舞台，及加载资源，传入canvas标签
    // <div id="cusEngine" style="line-height:0;font-size:0;position: absolute;">
    //     <canvas id="canvas" style="width: 100%;height: 100%"></canvas> //需要的canvas给个全屏，尽量用div包下
    // </div>
    await store.game.initStage(this.gameCanvas)
    //加鼠标事件，
    store.game.stage.addWebMouseEvent();
    //监听窗口尺寸改变
    window.addEventListener('resize', function () { store.game.stage.resize() });
    //展示游戏，传入数据
    store.game.showGame({
      targetStudy: gameStore.gameInfo.targetConfig.target1,//背包数量
      targetTravel: gameStore.gameInfo.targetConfig.target2,//飞机数量
      time: gameStore.gameInfo.countdownSeconds,//时间，秒计
      needGuide: store.indexData?.newGuideFlag == 1,
      handleLogExposure: handleLogExposure,
      handleLogClick: handleLogClick,
      // 退出游戏确认弹窗-曝光埋点
      exitPopSensorExposure: () => {
        pageView("b14611", {
          page_name: "退出提示弹窗",
        });
        sensorLog(LOG_KEY.exposure, "b14611", "d14613", {
          page_name: "退出提示弹窗",
          button_name: "确认按钮",
        });
        sensorLog(LOG_KEY.exposure, "b14611", "d14612", {
          page_name: "退出提示弹窗",
          button_name: "继续游戏按钮",
        });
      },
      // 退出游戏确认弹窗-确认按钮-点击埋点
      exitPopExitBtnSensorClick: () => {
        sensorLog(LOG_KEY.click, "b14611", "d14613", {
          page_name: "退出提示弹窗",
          button_name: "确认按钮",
        });
      },
      // 退出游戏确认弹窗-继续游戏按钮-点击埋点
      exitPopContinueBtnSensorClick: () => {
        sensorLog(LOG_KEY.click, "b14611", "d14612", {
          page_name: "退出提示弹窗",
          button_name: "继续游戏按钮",
        });
      }
    })
    if (store.indexData?.newGuideFlag == 1) {
      API.completeGuide({ flag: 2 })
    }
    //监听事件，比如游戏结果,gameResult|exitGame
    store.game.addGlobalEvent("gameResult", (e) => {
      console.log(e)//成功
      if (e.data === true) {
        //成功
        // 得分【1个背包100分，1个飞机1分】
        const score = gameStore.gameInfo.targetConfig.target1 * 100 + gameStore.gameInfo.targetConfig.target2 * 1; // TODO
        gameStore.submit(score, true)
      } else {
        const score = 0; // TODO
        gameStore.submit(score, false, e.data)
        // {
        //     targetStudy: 1,//还差合成数量
        //     targetTravel: 2,
        // }
      }
    })
    //退出游戏
    store.game.addGlobalEvent("exitGame", (e) => {
      PageCtrl.changePage(Homepage)
    })
    // store.game.addGlobalEvent("pauseGame", (e) => {
    //   console.log('暂停游戏')
    // })


    //派发事件，比如倒计时暂停,pauseGame|continueGame|restartGame
    //暂停游戏
    // store.game.dispatchGlobalEvent("pauseGame")
    //继续游戏
    // store.game.dispatchGlobalEvent("continueGame")
    //重玩游戏
    // store.game.dispatchGlobalEvent("restartGame", { targetStudy: 1, targetTravel: 1, time: 120 })

  }

  componentWillUnmount() {
    store.game.destroy()
  }

  render() {

    return <div className={styles.root} ref={(el) => this.gameDiv = el}>
      <canvas className={styles.gameCanvas} ref={(el) => this.gameCanvas = el} />
    </div>;
  }
}

export default GamePage;
