import { generateAPI } from "./utils"

const API = generateAPI({
  /** 获取活动规则 */
  getRule: "projectRule.query",
  /** 获取前端配置项 */
  getFrontVariable: "coop_frontVariable.query",
  /** 参与接口 post请求 */
  doJoin: {
    uri: "join.do",
    method: "post"
  },
  /** 签到 */
  doSign: {
    uri: "checkin_1/doSign.do",
    withToken: true,  // 携带token
  },

  // cookie丢失-临时保存cookie
  tempSaveCookie: {
    uri: "/autoLogin/tempSaveCookie",
    showMsg: false,
  },
  // cookie丢失-重新设置cookie
  resetCookie: "/autoLogin/resetCookie",
  userLogin: {
    uri: "userLogin.check",
    showMsg: false,
  },

  getInviteCode: {
    uri: 'customInvite1/getInviteCode.do',
    withToken: true,
    method: 'post',
  },
  doAssist: {
    uri: 'customInvite1/doAssist.do',
    withToken: true,
    method: 'post',
    // showMsg: false,
  },
  /** 获取地区 */
  getParentCode: "/gaw/address/getChildrenByParentCode",

  // 扣积分
  queryStatus: "credits/queryStatus.do",
  creditsCost: {
    uri: "credits/creditsCost.do",
    method: "post"
  },

  index: "game/index.do",
  completeGuide: {
    uri: "game/guide.do",
    withToken: true,
    method: "post",
  },

  /** 奖品页 */
  prize: "/crecord/getrecordmn",
  /** 获取任务列表 */
  getTaskInfo: {
    uri: "customTask1/queryTasks.do",
  },
  /** 完成任务 */
  doCompleted: {
    uri: "customTask1/finishTask.do",
    method: "post",
    withToken: true,
  },
  /** 领取奖励 */
  sendPrize: {
    uri: "customTask1/sendPrize.do",
    method: "post",
    withToken: true,
  },

  // 推送使用
  outside: {
    uri: `customInvite1/outside.do`,
    widthToken: true,
  },

  // 推送使用
  assistJoin: {
    uri: `customInvite1/join.do`,
    widthToken: true,
  },

  bindPhone: {
    uri: "/customActivity/piccLife/bindWithCode",
    method: "post",
    showMsg: false,
  },


  /** 扭蛋机首页 */
  drawIndex: "draw/info.do",
  /** 扭蛋机抽奖 */
  drawJoin: {
    uri: "draw/doDraw.do",
    withToken: true,
  },

  /** 校验验证码并登录 */
  coopCheckCode: {
    uri: "examine/coop_checkCode.do",
    method: "post",
  },

  getCode: {
    uri: "/customActivity/piccLife/sendSmsCode",
    // showMsg: false,
  },

  /** 发送验证码 */
  coopSendCode: {
    uri: "examine/coop_sendCode.do",
    method: "post",
  },
  /** 校验是否绑定手机号 */
  checkBind: "/customActivity/piccLife/check",

  ////////////////////////////////////////////////////////


  buriedPoint: {
    uri: "home/buriedPoint.do",
    showMsg: false,
  },

  /** 生成唤端二维码 */
  getLongLinkQrcode: `/customActivity/qrcode/getQrcode`,


  /**数据推送 */
  visit:`common/visit.do`,
  /** 绑定友客业务员信息接口 */
  bindYk: {
    uri: "game/bindYk.do",
    method: "post",
    showMsg: false,
  },
  /** 落地页 */
  coop_getLoadingInfo: "customInvite1/outside.do",

  ////////////////////////////// Game //////////////////////////////
  start: {
    uri: `game/start.do`,
    withToken: true,
  },
  suggest: {
    uri: `game/suggest.do`,
    withToken: true,
  },
  middleSubmit: {
    uri: `game/middleSubmit.do`,
    withToken: true,
  },
  submit: {
    uri: `game/submit.do`,
    withToken: true,
  },

   /** 同意隐私协议接口 */
  agreePrivacy: {
    uri: "game/agreePrivacy.do",
  },

})

// console.log('======', API)

export default API
