import { LevelBase } from "@/pages/GamePage/Components/LevelBase.ts";
import { Assets, Rectangle, Sprite } from "pixi.js";
import { Ease, Tween } from "@/core/tween";
import { GameEvent, globalEvent } from "@/pages/GamePage/GameEvent.ts";
import { rightWaitTime } from "@/pages/GamePage/Level/LevelConfig.ts";

export class Level20 extends LevelBase {

  level: number = 20;

  A: Sprite;
  B: Sprite;
  C: Sprite;

  right: Sprite;

  onLoad() {
    super.onLoad();

    this.addChild(new Sprite(Assets.get(`level${this.level}/box.png`)))
      .position.set(95, 959);

    this.A = this.addChild(new Sprite(Assets.get(`level${this.level}/A.png`)));
    this.A.position.set(84, 743);

    this.B = this.addChild(new Sprite(Assets.get(`level${this.level}/B.png`)));
    this.B.position.set(351, 664);

    this.C = this.addChild(new Sprite(Assets.get(`level${this.level}/C.png`)));
    this.C.position.set(536, 839);

    this.addChild(this.qs);

    const top = this.addChild(new Sprite(Assets.get(`level${this.level}/top.png`)))
    top.position.set(95, 970);
    top.interactive = false;
    top.eventMode = "none";

    this.right = this.addChild(new Sprite(Assets.get(`common/right.png`)));
    this.right.position.set(503, 1146);
    this.right.alpha = 0;
    this.right.interactive = false;
    this.right.eventMode = "none";

    [this.A, this.B, this.C, this.qs].forEach((item) => {
      item.on("pointerdown", this.onAPointerDown, this);
      item.on("pointerup", this.onAPointerUp, this);
      item.on("globalpointermove", this.onAPointerMove, this);
    });

  }

  target: Sprite = null;
  pos: { x: number, y: number } = null;

  onAPointerUp(e) {
    this.pos = null;
    this.target = null;
  }

  onAPointerDown(e) {
    this.target = e.target;
    const { x, y } = e.data.global;
    this.pos = {
      x: x - e.target.x,
      y: y - e.target.y
    }
  }

  onAPointerMove(e) {
    if (!this.pos) return;
    const { x, y } = e.data.global;
    const nx = x - this.pos.x;
    const ny = y - this.pos.y;
    this.target.position.set(nx, ny);

    this.check();
  }

  check() {

    const { x: ax, y: ay, width: aw, height: ah } = this.target;

    const isIns = new Rectangle(ax, ay, aw, ah)
      .intersects(new Rectangle(280, 1000, 260, 180));

    if (isIns) {

      this.target.eventMode = "none";
      this.target.interactive = false;

      const pos = new Map([
        [this.A, { x: 184, y: 864 }],
        [this.B, { x: 285, y: 854 }],
        [this.C, { x: 370, y: 905 }],
        [this.qs, { x: 255, y: 950, angle: 45 }],
      ]).get(this.target);

      Tween.get(this.target)
        .to({ x: pos.x, y: pos.y, angle: pos.angle || 0 }, 666, Ease.quadInOut);

      this.target = null;
      this.pos = null;

      if (
        !this.A.interactive
        && !this.B.interactive
        && !this.C.interactive
        && !this.qs.interactive
      ) {
        this.setPauseCd(true);
        Tween.get(this.right)
          .to({ alpha: 1 }, 666, Ease.quadInOut)
          .wait(rightWaitTime)
          .call(() => {
            globalEvent.emit(GameEvent.NextLevel);
          });
      }

    }

  }

  onDestroy() {
    super.onDestroy();
    Tween.removeTweens(this.right);
    [this.A, this.B].forEach((item) => {
      item.off("globalpointermove", this.onAPointerMove, this);
    });
  }

}
