import { Base, IBase } from "@/core/pixi/base/Base.ts";
import { Assets, Container, Sprite, Ticker } from "pixi.js";

export abstract class LevelBase extends Base {

  abstract level: number;
  qs: Sprite;

  setPauseCd: (pause: boolean) => void;

  constructor(setPauseCd) {
    super();
    this.setPauseCd = setPauseCd;
  }

  onLoad() {
    this.qs = this.addChild(new Sprite(Assets.get(`level${this.level}/qs.png`)));
    this.qs.anchor.set(0.5);
    this.qs.position.set(375, 505);
  }

  setTouchEnable(enable: boolean) {
    this.interactive = enable;
    this.interactiveChildren = enable;
  }

  onUpdate(time: Ticker) {

  }

  onDestroy() {
  }

  destroy() {
    this.onDestroy();
    super.destroy();
  }

}
