'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './index.less';
import { _asyncThrottle, _throttle } from '../../utils/utils.ts';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import store from "@/store/store.js";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import HomePage from '@/pages/HomePage/HomePage.tsx';

@observer
class AwardPopup extends React.Component {
    constructor(props) {
        super(props);
    }

    //关闭
    onClose = () => {
        ModalCtrl.closeModal();
    }

    //开心收下
    onReceive = ()=>{
        ModalCtrl.closeModal();
    }

    render() {
        return (
            <div className="AwardPopup">
                <div className="ap_mask"></div>
                <div className='ap_bg'>
                    <div className='ap_txt'>成功获得奖品</div>
                    <div className='ap_icon'></div>
                    <div className='ap_award_name'>奖品名称</div>
                    <div className='ap_btn' onClick={()=>this.onReceive()}></div>
                </div>
                <div className='ap_close' onClick={()=>this.onClose()}></div>
            </div>
        );
    }
};

export default AwardPopup;