'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './index.less';
import { _asyncThrottle, _throttle } from '../../utils/utils.ts';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import store from "@/store/store.js";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import HomePage from '@/pages/HomePage/HomePage.tsx';

@observer
class FailPopup extends React.Component {
    constructor(props) {
        super(props);
        this.state = props;
        // {
        //     targetStudy: 1,//还差合成数量，飞机
        //     targetTravel: 2//书包
        // }
    }

    //关闭
    onClose = () => {
        ModalCtrl.closeModal();
        PageCtrl.changePage(HomePage);//回到首页
    }

    //再玩一次
    onReceive = () => {
        ModalCtrl.closeModal();
        //重玩游戏
        if (store.game) {
            store.game.dispatchGlobalEvent("restartGame", { targetStudy: 1, targetTravel: 1, time: 120 })
        }
    }

    render() {
        const { leftGameTimes } = store?.indexData || {}
        return (
            <div className="FailPopup">
                <div className="fp_mask"></div>
                <div className='fp_bg'>
                    <div className='fp_txt'>还需要合成以下个数才可解锁地标</div>
                    <div className='fp_icon'>
                        <div className='fp_mb_1'>还差{this.state?.targetTravel}个</div>
                        <div className='fp_mb_2'>还差{this.state?.targetStudy}个</div>
                    </div>
                    <div className='fp_btn' onClick={() => this.onReceive()}>
                        <div className='fp_btn_txt'>剩余次数：{leftGameTimes}</div>
                    </div>
                </div>
                <div className='fp_close' onClick={() => this.onClose()}></div>
            </div>
        );
    }
};

export default FailPopup;