'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './sharepage.less';
import { _throttle, getUrlParam, windowJumpUrl } from '@/utils/utils.ts';
// import { accessLog } from 'duiba-utils';
// import store from '@/store';
import API from '@/api';
import { extranceName } from '@/utils/constants.ts';
import shareStore from '../../store/share.js';
import { LOG_KEY, MatterShareOpt, MatterViewDuration, MatterViewOpt, sensorLog } from '../../utils/sensors.js';

@observer
class AgentSharepage extends React.Component {
  constructor(props) {
    super(props);

    this.state = {
      shareInfo: {}
    }
    this.startTime = +new Date();
    this.shareRef = null;
  }

  async componentDidMount() {

    MatterViewOpt("b14316", {
      page_name: "落地页",
    });

    sensorLog(LOG_KEY.exposure, "b14316", "d14317", {
      page_name: "落地页",
      button_name: "分享活动",
    });
    // await store.checkBindStatus();
    // await this.getShareInfo();

    // setTimeout(() => {
    //   this.shareRef.scrollTo(0, 70)
    // }, 50)
  }

  componentWillUnmount() {
    MatterViewDuration("b14316", +new Date() - this.startTime, {
      page_name: "落地页",
    });

  }

  getShareInfo = async () => {
    const { success, data } = await API.coop_getLoadingInfo();
    if (success && data) {
      this.setState({
        shareInfo: data
      })
    }
  }

  /** 跳转微信端活动 */
  toWeActHandle = () => {
    CFG.workerCode = getUrlParam("ykCode");
    let url = CFG.domain + CFG.indexUrl + '&channel=' + CFG.channel + `${!!getUrlParam("inviteCode") ? ("&inviteCode=" + getUrlParam("inviteCode")) : ""}` + `${!!CFG.workerCode ? `&ykCode=${CFG.workerCode}` : ""}`
    MatterViewDuration("b14316", +new Date() - this.startTime, {
      page_name: "落地页",
    });
    setTimeout(() => {
      location.href = url;
    }, 500)
  }

  handleShareAct = _throttle(() => {
    MatterShareOpt("b14316", "d14317", {
      button_name: "分享活动按钮",
      page_name: "落地页",
    })

    console.log("share")
    shareStore.doShare()
  })

  render() {
    // const { actStartTimestamp, actEndTimestamp } = this.state?.shareInfo || {};
    return (
      <div className="agentsharepage_wrap" ref={r => this.shareRef = r}>
        <div className="sharepage modal_center">
          <span className="bg"></span>
          <span className="normal_btn md27" onClick={this.handleShareAct}></span>
        </div>
      </div>
    );
  }
}
export default AgentSharepage;
