'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './index.less';
import { _asyncThrottle, _throttle } from '../../utils/utils.ts';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import store from "@/store/store.js";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import HomePage from '@/pages/HomePage/HomePage.tsx';

const cities = [
  { spId: 'sp_landmark1', name: '北京', md: 'md30' },
  { spId: 'sp_landmark2', name: '西安', md: 'md31' },
  { spId: 'sp_landmark3', name: '上海', md: 'md32' },
  { spId: 'sp_landmark4', name: '杭州', md: 'md33' },
  { spId: 'sp_landmark5', name: '成都', md: 'md34' }
];

@observer
class MapInfoPopup extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            spId: props.spId,
            md: cities.find(city=>city.spId === props.spId)?.md
        }
    }

    //关闭
    onClose = () => {
        ModalCtrl.closeModal();
    }

    render() {
        const { spId, md } = this.state;
        return (
            <div className="MapInfoPopup">
                <div className="mip_mask"></div>
                <div className={'mip_bg mip_bg_' + spId}>
                </div>
                <div className={'mip_close ' + md} onClick={() => this.onClose()}></div>
            </div>
        );
    }
};

export default MapInfoPopup;