'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './index.less';
import { _asyncThrottle, _throttle } from '../../utils/utils.ts';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import store from "@/store/store.js";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import HomePage from '@/pages/HomePage/HomePage.tsx';
import { SvgaPlayer } from '@grace/svgaplayer';
import output1Svga from "../../assets/giftPackPopup/5.svga";
import AwardPopup from '@/panels/AwardPopup/index.jsx'
import NotWinPopup from '@/panels/NotWinPopup/index.jsx'
import API from '@/api/index';
//礼包动效弹窗
@observer
class GiftPackPopup extends React.Component {
    constructor(props) {
        super(props);
    }

    componentDidMount() {
        this.lottteryHandle();

    }
    // 开始抽奖
    lottteryHandle = _asyncThrottle(async () => {
        const { success, data } = await API.drawJoin();
        if (success && data) {//中奖
            setTimeout(() => {
                ModalCtrl.closeModal();
                ModalCtrl.showModal(AwardPopup, data);
            }, 3000);
        } else {//未中奖
            setTimeout(() => {
                ModalCtrl.showModal(NotWinPopup);
            }, 3000);
        }
    });
    //关闭
    onClose = () => {
        // ModalCtrl.closeModal();
    }

    render() {
        return (
            <div className="GiftPackPopup" onClick={() => this.onClose()}>
                <div className="gpp_mask"></div>
                {/* <div className='gpp_icon'></div> */}
                <SvgaPlayer className="output1" src={output1Svga} />
            </div>
        );
    }
};

export default GiftPackPopup;