import React from 'react';
import { observer } from 'mobx-react';
import store from "@/store/store.ts";

import styles from "./GamePage.module.less";
import { Application, Assets, Sprite, Ticker } from "pixi.js";
import { initBundle } from "@/core/pixi/Helper.ts";
import { Tween } from "@/core/tween";
import "@/core/pixi/base/mix.ts";

import { initDevtools } from '@pixi/devtools';
import { Button } from "@grace/ui";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import gameStore from "@/store/gameStore.ts";

import.meta.env.DEV && initDevtools({});

import { _throttle } from "@/utils/utils.ts";
import { GameEvent, globalEvent } from "@/pages/GamePage/GameEvent.ts";
import { LOG_KEY, pageView, sensorLog } from "@/utils/sensors";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import FailPopup from '@/panels/FailPopup/index.jsx'
import VictoryPopup from '@/panels/VictoryPopup/index.jsx'


import "./js/output";
import API from '@/api';

declare const Game: any;

@observer
class GamePage extends React.Component<any, any> {

  gameCanvas: HTMLCanvasElement = null;
  gameDiv: HTMLDivElement = null;
  app: Application = null;
  game = null;

  async componentDidMount() {
    // import { Game } from "./output.js" |  window[Game]
    //实例，传入资源路径
    // const store.game = this.store.game = new Game("./released/resource/")
    // https://yun.duiba.com.cn/db_games/RB_yanxue/250620/index.html
    store.game = this.game = new Game("https://yun.duiba.com.cn/db_games/RB_yanxue/250620/resource/")
    //可预加载资源
    store.game.preLoad();
    //初始化舞台，及加载资源，传入canvas标签
    // <div id="cusEngine" style="line-height:0;font-size:0;position: absolute;">
    //     <canvas id="canvas" style="width: 100%;height: 100%"></canvas> //需要的canvas给个全屏，尽量用div包下
    // </div>
    await store.game.initStage(this.gameCanvas)
    //加鼠标事件，
    store.game.stage.addWebMouseEvent();
    //监听窗口尺寸改变
    window.addEventListener('resize', function () { store.game.stage.resize() });
    //展示游戏，传入数据
    store.game.showGame({
      targetStudy: 1,//背包数量
      targetTravel: 1,//飞机数量
      time: 120,//时间，秒计
      needGuide: store.indexData?.newGuideFlag == 1,
    })
    if (store.indexData?.newGuideFlag == 1) {
      API.completeGuide({ flag: 2 })
    }
    //监听事件，比如游戏结果,gameResult|exitGame
    store.game.addGlobalEvent("gameResult", (e) => {
      console.log(e)//成功
      if (e.data === true) {
        //成功
        let param = { "recordId": 1234, "score": 507, "success": true, "timestamp": 1749800591737 }
        this.submitGame(param)
      } else {
        console.log(e.data)
        ModalCtrl.showModal(FailPopup, e.data);
        // {
        //     targetStudy: 1,//还差合成数量
        //     targetTravel: 2,
        // }
      }
    })
    store.game.addGlobalEvent("exitGame", (e) => {
      //自行切换，游戏有需要就销毁
      store.game.destroy()
    })

    store.game.addGlobalEvent("pauseGame", (e) => {
      console.log(123123123)
    })


    //派发事件，比如倒计时暂停,pauseGame|continueGame|restartGame
    //暂停游戏
    // store.game.dispatchGlobalEvent("pauseGame")
    //继续游戏
    // store.game.dispatchGlobalEvent("continueGame")
    //重玩游戏
    store.game.dispatchGlobalEvent("restartGame", { targetStudy: 1, targetTravel: 1, time: 120 })

  }

  componentWillUnmount() {

  }

  //提交游戏
  submitGame = async (param) => {
    let gameData: any = await API.submitGame({ param: param })
    gameData = {
      "success": true,
      "code": "",
      "message": "",
      "data": {
        "gotSpInfo": {
          "spId": "sp_landmark1",
          "name": "北京",
          "icon": "https://www.baidu.com/tiananmen.png"
        },
        "rewardDrawTimes": 1,
        "leftGameTimes": 2
      }
    }
    if (gameData.data?.gotSpInfo) {
      ModalCtrl.showModal(VictoryPopup, gameData.data);
    }
  }


  render() {

    return <div className={styles.root} ref={(el) => this.gameDiv = el}>
      <canvas className={styles.gameCanvas} ref={(el) => this.gameCanvas = el} />
    </div>;
  }
}

export default GamePage;
