import { Toast } from "@grace/ui";
// import { callApi } from "@spark/api-base";
import { getDomain } from "@spark/dbdomain";
import {Axios} from 'axios';
const apiAxios = new Axios({
  timeout: 10000,
});

/** 处理cookie */
export const saveCookies = async () => {
  const domain = await getDomain();
  // const data = await callApi(`${domain}/autoLogin/tempSaveCookie`);
  const resInfo = await apiAxios.request({
    method: 'get',
    url: `${domain}/autoLogin/tempSaveCookie`,
  })
  const res = JSON.parse(resInfo.data)
  console.log('res',res)
  if (!res?.success) {
      return;
  }
  if (!!res.data) {
    localStorage.setItem("cookieId", res.data);
  }
};

/** 设置cookies */
export const setCookies = async () => {
  const cookieId = localStorage.getItem("cookieId");
  const domain = await getDomain();
  if (!!cookieId) {
  //   await callApi(`${domain}/autoLogin/resetCookie?duibaTempCookieId=${cookieId}`);
      const resInfo = await apiAxios.request({
        method: 'get',
        url: `${domain}/autoLogin/resetCookie?duibaTempCookieId=${cookieId}`,
      })
      // const res = JSON.parse(resInfo.data)
      localStorage.removeItem("cookieId");
  }
};
