"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./longImgPop.less";
import { _throttle } from "@/utils/utils.ts";
import DPlayer from "dplayer";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import Taskpop from "../taskpop/taskpop";
import { Button } from "@grace/ui";

@observer
class LongImgPop extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      isFinish: false,
      countdownTime: 15, // 单位s
    };
    this.timer = "";
    this.isStart = false;
    this.stop = false;
    this.dp = null;
  }

  componentDidMount() {
    console.log('this.props?.type',this.props?.type)
    if (this.props?.type == 2) {
      this.dp = new DPlayer({
        container: this.videoNode,
        video: {
          url: this.props?.imgUrl,
        },
        loop: true,
      });
      this.dp.on("play", () => {
        this.startInterval();
      });
      this.dp.on("pause", () => {
        // this.endCountDown()
      });
    }
    if (this.props?.noCount) {
      this.setState({
        isFinish: true,
      });
    } else {
      if(this.props?.type == 2) return
      this.startInterval();
    }
  }

  componentWillUnmount() {
    if (this.timer) clearInterval(this.timer);
  }

  /** 开始倒计时 */
  startInterval = () => {
    if (this.timer) clearInterval(this.timer);
    this.timer = setInterval(async () => {
      if (this.state.countdownTime === 0) {
        this.setState({
          isFinish: true,
        });
        clearInterval(this.timer);
        this.timer = "";
        // 完成任务
        const { taskSucCb } = this.props || {};
        taskSucCb && taskSucCb();
        return;
      }
      this.setState({
        countdownTime: Math.max(0, this.state.countdownTime - 1),
      });
    }, 1000);
  };

  /** 关闭当前页面 */
  closeHandle = () => {
    ModalCtrl.closeModal()
    if (!this.props.noCount) {
      ModalCtrl.showModal(Taskpop)
    }
  };

  render() {
    const { imgUrl, type } = this.props || {};
    const { isFinish, countdownTime } = this.state;
    return (
      <div className="longImgPop">
        {type == 1 && <img src={imgUrl} alt="" className="mainImg" />}
        {type == 2 && (
          <div className="v-wrapper">
            <div ref={(node) => (this.videoNode = node)} id="my-player" className="video-js"></div>
          </div>
        )}

        <Button className="back_home" onClick={this.closeHandle}></Button>
        {!isFinish && <span className="countdown">{`${countdownTime}s`}</span>}
      </div>
    );
  }
}

export default LongImgPop;
