import { LevelBase } from "@/pages/GamePage/Components/LevelBase.ts";
import { Assets, Sprite } from "pixi.js";
import { Tween } from "@/core/tween";
import { GameEvent, globalEvent } from "@/pages/GamePage/GameEvent.ts";

export class Level2 extends LevelBase {

  level: number = 2;

  A: Sprite;
  B: Sprite;
  C: Sprite;
  D: Sprite;

  right: Sprite;
  error: Sprite;

  onLoad() {
    super.onLoad();

    this.addChild(new Sprite(Assets.get(`level${this.level}/题图.png`)))
      .position.set(246, 687);

    this.A = this.addChild(new Sprite(Assets.get(`level${this.level}/A.png`)));
    this.A.position.set(67, 1111);

    this.B = this.addChild(new Sprite(Assets.get(`level${this.level}/B.png`)));
    this.B.position.set(243, 1111);

    this.C = this.addChild(new Sprite(Assets.get(`level${this.level}/C.png`)));
    this.C.position.set(404, 1111);

    this.D = this.addChild(new Sprite(Assets.get(`level${this.level}/D.png`)));
    this.D.position.set(566, 1111);

    this.right = this.addChild(new Sprite(Assets.get(`level${this.level}/right.png`)));
    this.right.visible = false;
    this.right.interactive = false;

    this.error = this.addChild(new Sprite(Assets.get(`level${this.level}/error.png`)));
    this.error.visible = false;
    this.error.interactive = false;

    [this.A, this.B, this.C, this.D]
      .forEach((item) => {
        item.on("pointertap", this.onTapOption.bind(this, item));
      });

  }

  onTapOption(item: Sprite) {
    const isRight = item === this.D;
    this.setTouchEnable(false);
    const dp = -7;
    const wait = 2000;

    if (isRight) {
      this.right.visible = true;
      this.right.position.set(item.x + dp, item.y + dp);
      Tween.get(this.error)
        .wait(wait)
        .call(() => {
          globalEvent.emit(GameEvent.NextLevel);
        });
    } else {
      this.error.visible = true;
      this.error.position.set(item.x + dp, item.y + dp);
      Tween.removeTweens(this.error);
      Tween.get(this.error)
        .wait(wait)
        .call(() => {
          this.error.visible = false;
          this.setTouchEnable(true);
        });
    }

  }

  onDestroy() {
    super.onDestroy();
    Tween.removeTweens(this.error);
  }

}
