import React from "react";
import {observer} from "mobx-react";
import "./CodePop.less";
import QRCode from "qrcode";
import store from '../../store/store';
import { Button } from '@grace/ui';
import {_asyncThrottle} from "../../utils/utils";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import { LOG_KEY, MatterShareOpt, MatterViewDuration, MatterViewOpt, pageView, sensorLog } from "../../utils/sensors.js";

@observer
class CodePop extends React.Component {

  state = {
    codeImg: ""
  };

  componentDidMount = async () => {
    await this.creatCode();
    pageView("b14292", {
      page_name: "换端弹窗",
    });
    sensorLog(LOG_KEY.exposure, "b14292", "d14293", {
      page_name: "换端弹窗",
      button_name: "关闭按钮",
    });
  };

  /** 生成二维码*/
  creatCode = async () => {
    await store.getFrontVariable();
    const url = await QRCode.toDataURL(store.frontVariable?.Url,{
      errorCorrectionLevel: 'L', // 纠错级别，可选值：'L'、'M'、'Q'、'H'
      margin: 1, // 边距，单位：像素
    });
    this.setState({
      codeImg: url
    });
  };

  /** 关闭 */
  clickClose = () => {
    ModalCtrl.closeModal()
    sensorLog(LOG_KEY.click, "b14292", "d14293", {
      page_name: "换端弹窗",
      button_name: "关闭按钮",
    });
  };

  render() {
    const {codeImg} = this.state;
    return <div className="CodePop modal_center">
      <div className="light"/>
      <div className="bg">
        <img className="code" src={codeImg}/>
      </div>
      <Button className="close" onClick={this.clickClose}/>
    </div>;
  }
}

export default CodePop;
