import React, { useState } from "react";
import { observer } from "mobx-react";
import "./FillAddress.less";
import { REG_TEL, _throttle } from "@/utils/utils.ts";
import { Toast } from "@grace/ui";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import {Axios} from 'axios';
import Selectmodal from "../selectmodal/selectmodal.jsx";
import { LOG_KEY, MatterShareOpt, MatterViewOpt, pageView, sensorLog,MatterViewDuration } from '../../utils/sensors';
const apiAxios = new Axios({
    timeout: 10000,
  });
@observer
class FillAddress extends React.Component {
  fillMd=false
  state = {
    name: "",
    mobile: "",
    area: "",
    province: "",
    city: "",
    street: "",
    detail: "",
    addrCode: "",
    isShowArea:false,
  }

  componentDidMount() {
    this.initSensor();
    const { projectId, saveAddresUrl, getPrize, recordId, agentCode, prizeProjectId} = this.props;
    console.log('projectId',projectId)

    
  }

  initSensor(){
    pageView("b14636", {
      page_name: "地址填写页"
    });
    sensorLog(LOG_KEY.exposure, "b14636", "d14637", {
      page_name: "地址填写页",
      button_name: "提交信息按钮",
    });
  }

  ClickClose = () => {
    ModalCtrl.closeModal();
  }

  onNameInput = (e) => {
    let value = e.target.value
    this.setState({
      name: value,
    });
  };

  onMobileInput = (e) => {
    this.setState({
      mobile: e.target.value.replace(/[^\d]/g, ''),
    });
  };

  onDetailInput = (e) => {
    let value = e.target.value;
    this.setState({
      detail: value,
    });
  };

  clickArea = () => {
    // ModalCtrl.showModal(Selectmodal,{
    //   doSelect: this.doSelect,
    // })
    this.setState({
      isShowArea:true
    })
  }

  doSelect = ({province, city, area, street, addrCode,}) => {
    this.setState({
      province,
      city,
      area,
      street,
      addrCode,
    },()=>{
      this.closeSelect()
    });
  }
  closeSelect = () =>{
    this.setState({
      isShowArea:false
    })
  }

  clickSubmit = _throttle(async () => {
    sensorLog(LOG_KEY.click, "b14636", "d14637", {
      page_name: "地址填写页",
      button_name: "提交信息按钮",
    });

    const {
      name, mobile,
      area, province, city, street, addrCode,
      detail
    } = this.state;

    if (!REG_TEL.test(mobile)) {
      return Toast.show('请输入正确的手机号～');
    }
    const { projectId, saveAddresUrl, getPrize, recordId, agentCode, prizeProjectId} = this.props;
    const params= {
      province,
      city,
      area,
      detail,
      name,
      mobile,
      recordId,
      agentCode,
      street,
      projectId:prizeProjectId,
      addrCode,
      from: CFG.channel || "2",
      actPlatforms: CFG.actPlatforms,
      actId: CFG.actId,
    }
    const resInfo = await apiAxios.request({
      method: 'get',
      url: saveAddresUrl,
      params,
    })
    const res = JSON.parse(resInfo.data)
    console.log('res',res)
    if (!res?.success) {
        return;
    }
    
    getPrize(projectId);
    ModalCtrl.closeModal();

  });

  clickSubmitNoAct = () => {
    Toast.show("请先填写完整信息", 1800, {hideOthers: true});
  }

  render() {

    const {name, mobile, area, province, city, street, detail, isShowArea} = this.state;

    const isFill = Boolean(name && mobile && area && province && city && detail);
    if(this.fillMd != isFill){
      console.log("曝光埋点")
      this.fillMd = isFill;
    }
    return <div className="FillAddress">
      <div className="bg" />
      <div className="title" />
      <div className="button-return" onClick={this.ClickClose} />

      <div className="infoList">
        <div className="inputG inputName">
          <div className="igLabel">收货人</div>
          <input
            className="igInput inputStyle"
            placeholder="收货人姓名"
            value={name}
            maxLength={10}
            onChange={this.onNameInput}
          />
        </div>

        <div className="inputG inputMobile">
          <div className="igLabel">手机号码</div>
          <input
            className="igInput inputStyle"
            placeholder="收货人手机号码"
            value={mobile}
            maxLength="11"
            onChange={this.onMobileInput}
          />
        </div>

        <div className="inputG inputArea">
          <div className="igLabel">所在地区</div>
          <div
            className={`igDiv ${province ? "" : "igInputGray"}`}
            placeholder="选择省/市/区"
            onClick={this.clickArea}
          >
            {province ? `${province}/${city}/${area}${!!street ? `/${street}` : ""}` : "选择省/市/区/街道"}
          </div>
          <div className="button-select" onClick={this.clickArea} />
        </div>

        <div className="inputG inputAddress">
          <div className="igLabel">详细地址</div>
          <input
            className="igInput inputStyle"
            placeholder="请填写详细地址"
            value={detail}
            onChange={this.onDetailInput}
            maxLength={100}
          />
        </div>
      </div>

      {
        isFill
          ? <div className="submitAct" onClick={this.clickSubmit} />
          : <div className="submitNoAct" onClick={this.clickSubmitNoAct} />
      }
      {
        isShowArea && <Selectmodal doSelect={this.doSelect} closeSelect={this.closeSelect}></Selectmodal>
      }
    </div>;
  }
}

export default FillAddress;
