import React from 'react';
import { observer } from 'mobx-react';
import './RankPage.less';
import API from "@/api";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import store from "@/store/store.ts";
import HomePage from '../HomePage/HomePage';
import Countdown from '@/components/ComCountdown/index.jsx';
import { LOG_KEY, MatterShareOpt, MatterViewOpt, pageView, sensorLog,MatterViewDuration } from '../../utils/sensors.js';
@observer
class RankPage extends React.Component<any, any> {
    constructor(props) {
        super(props);
        this.state={
            rankList:[],
            myRankInfo:{},
            prizeList:[],
            openTime:0,
            currentTime:0,
        }
    }
    componentDidMount(): void {
        this.getRankInfo();
        pageView("b14286", {
            page_name: "排行榜页面",
        });
    
        sensorLog(LOG_KEY.exposure, "b14286", "d14287", {
            page_name: "排行榜页面",
            button_name: "返回按钮",
        });
    }
    getRankInfo = async() =>{
        const {success, data, timeStamp} = await API.rankInfo()
        if(success){
            this.setState({
                rankList:data.rankInfos,
                myRankInfo:data.myRank,
                prizeList:data.rankOptions,
                openTime:data.openTime,
                currentTime:timeStamp,
            })
        }
    }
    clickBack = () => {
        sensorLog(LOG_KEY.click, "b14286", "d14287", {
            page_name: "排行榜页面",
            button_name: "返回按钮",
        });
        PageCtrl.changePage(HomePage);
    }

    render() {
        const {rankList, myRankInfo, prizeList, openTime, currentTime} = this.state;
        return <div className="rankPage">
            <div className="bg"></div>
            <div className="title"></div>
            <div className="countTime">
                <Countdown
                  leftT={openTime - currentTime}
                  renderText={data => {
                    const { day, hour, minute, second } = data
                    return <div className="times">
                      <span className="open_countdown_num">{day}</span>天
                      <span className="open_countdown_num">{hour}</span>:
                      <span className="open_countdown_num">{minute}</span>:
                      <span className="open_countdown_num">{second}</span>
                      后更新
                    </div>
                  }}
                  countdownOver={() => this.getRankInfo()}
                />
              </div>
            <div className="prizeList">
                {
                    (prizeList || []).map((item,index)=>{
                        return(
                            <div className="prizeItem" key={index}>
                                <div className="prizeImg">
                                    <img src={item?.image} alt="" />
                                </div>
                                <div className="prizeName">{item?.name}</div>
                                <div className="rank">第{item?.ranking}名</div>                
                            </div>
                        )
                    })
                }
                
                
            </div>
            <div className="rankTitle">
                <div className="title1">排名</div>
                <div className="title2">用户昵称</div>
                <div className="title3">成功组局数/月</div>
            </div>
            <div className="myRankInfo">
                <div className="title1">{myRankInfo?.index}</div>
                <div className="title2">{myRankInfo?.userName}(我)</div>
                <div className="title3">{myRankInfo?.score}</div>
            </div>
            <div className="rankList">
                {
                    (rankList || []).map((item,index)=>{
                        return(
                            <div className="rankItem">
                                <div className="rank">
                                    {item?.index < 4 ? <span></span> : item?.index}
                                </div>
                                <div className="name">{item?.userName}</div>
                                <div className="score">{item?.score}</div>
                            </div>
                        )
                    })
                }
                
            </div>
            <span className="back" onClick={this.clickBack}></span>
        </div>;
    }
}

export default RankPage;